/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.keyspaces.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class TableCapacitySpecification {
    @Nullable
    private Integer readCapacityUnits;
    @Nullable
    private String throughputMode;
    @Nullable
    private Integer writeCapacityUnits;

    private TableCapacitySpecification() {
    }

    public Optional<Integer> readCapacityUnits() {
        return Optional.ofNullable(this.readCapacityUnits);
    }

    public Optional<String> throughputMode() {
        return Optional.ofNullable(this.throughputMode);
    }

    public Optional<Integer> writeCapacityUnits() {
        return Optional.ofNullable(this.writeCapacityUnits);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TableCapacitySpecification defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer readCapacityUnits;
        @Nullable
        private String throughputMode;
        @Nullable
        private Integer writeCapacityUnits;

        public Builder() {
        }

        public Builder(TableCapacitySpecification defaults) {
            Objects.requireNonNull(defaults);
            this.readCapacityUnits = defaults.readCapacityUnits;
            this.throughputMode = defaults.throughputMode;
            this.writeCapacityUnits = defaults.writeCapacityUnits;
        }

        @CustomType.Setter
        public Builder readCapacityUnits(@Nullable Integer readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        @CustomType.Setter
        public Builder throughputMode(@Nullable String throughputMode) {
            this.throughputMode = throughputMode;
            return this;
        }

        @CustomType.Setter
        public Builder writeCapacityUnits(@Nullable Integer writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public TableCapacitySpecification build() {
            TableCapacitySpecification o = new TableCapacitySpecification();
            o.readCapacityUnits = this.readCapacityUnits;
            o.throughputMode = this.throughputMode;
            o.writeCapacityUnits = this.writeCapacityUnits;
            return o;
        }
    }
}

