/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.kinesisanalyticsv2.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ApplicationApplicationConfigurationVpcConfiguration {
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    @Nullable
    private String vpcConfigurationId;
    @Nullable
    private String vpcId;

    private ApplicationApplicationConfigurationVpcConfiguration() {
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public Optional<String> vpcConfigurationId() {
        return Optional.ofNullable(this.vpcConfigurationId);
    }

    public Optional<String> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationApplicationConfigurationVpcConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        @Nullable
        private String vpcConfigurationId;
        @Nullable
        private String vpcId;

        public Builder() {
        }

        public Builder(ApplicationApplicationConfigurationVpcConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.vpcConfigurationId = defaults.vpcConfigurationId;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = Objects.requireNonNull(securityGroupIds);
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcConfigurationId(@Nullable String vpcConfigurationId) {
            this.vpcConfigurationId = vpcConfigurationId;
            return this;
        }

        @CustomType.Setter
        public Builder vpcId(@Nullable String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public ApplicationApplicationConfigurationVpcConfiguration build() {
            ApplicationApplicationConfigurationVpcConfiguration o = new ApplicationApplicationConfigurationVpcConfiguration();
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.vpcConfigurationId = this.vpcConfigurationId;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

