/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.kms.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@CustomType
public final class GetPublicKeyResult {
    private String arn;
    private String customerMasterKeySpec;
    private List<String> encryptionAlgorithms;
    @Nullable
    private List<String> grantTokens;
    private String id;
    private String keyId;
    private String keyUsage;
    private String publicKey;
    private String publicKeyPem;
    private List<String> signingAlgorithms;

    private GetPublicKeyResult() {
    }

    public String arn() {
        return this.arn;
    }

    public String customerMasterKeySpec() {
        return this.customerMasterKeySpec;
    }

    public List<String> encryptionAlgorithms() {
        return this.encryptionAlgorithms;
    }

    public List<String> grantTokens() {
        return this.grantTokens == null ? List.of() : this.grantTokens;
    }

    public String id() {
        return this.id;
    }

    public String keyId() {
        return this.keyId;
    }

    public String keyUsage() {
        return this.keyUsage;
    }

    public String publicKey() {
        return this.publicKey;
    }

    public String publicKeyPem() {
        return this.publicKeyPem;
    }

    public List<String> signingAlgorithms() {
        return this.signingAlgorithms;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetPublicKeyResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String customerMasterKeySpec;
        private List<String> encryptionAlgorithms;
        @Nullable
        private List<String> grantTokens;
        private String id;
        private String keyId;
        private String keyUsage;
        private String publicKey;
        private String publicKeyPem;
        private List<String> signingAlgorithms;

        public Builder() {
        }

        public Builder(GetPublicKeyResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.customerMasterKeySpec = defaults.customerMasterKeySpec;
            this.encryptionAlgorithms = defaults.encryptionAlgorithms;
            this.grantTokens = defaults.grantTokens;
            this.id = defaults.id;
            this.keyId = defaults.keyId;
            this.keyUsage = defaults.keyUsage;
            this.publicKey = defaults.publicKey;
            this.publicKeyPem = defaults.publicKeyPem;
            this.signingAlgorithms = defaults.signingAlgorithms;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder customerMasterKeySpec(String customerMasterKeySpec) {
            this.customerMasterKeySpec = Objects.requireNonNull(customerMasterKeySpec);
            return this;
        }

        @CustomType.Setter
        public Builder encryptionAlgorithms(List<String> encryptionAlgorithms) {
            this.encryptionAlgorithms = Objects.requireNonNull(encryptionAlgorithms);
            return this;
        }

        public Builder encryptionAlgorithms(String ... encryptionAlgorithms) {
            return this.encryptionAlgorithms(List.of(encryptionAlgorithms));
        }

        @CustomType.Setter
        public Builder grantTokens(@Nullable List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        public Builder grantTokens(String ... grantTokens) {
            return this.grantTokens(List.of(grantTokens));
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder keyId(String keyId) {
            this.keyId = Objects.requireNonNull(keyId);
            return this;
        }

        @CustomType.Setter
        public Builder keyUsage(String keyUsage) {
            this.keyUsage = Objects.requireNonNull(keyUsage);
            return this;
        }

        @CustomType.Setter
        public Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey);
            return this;
        }

        @CustomType.Setter
        public Builder publicKeyPem(String publicKeyPem) {
            this.publicKeyPem = Objects.requireNonNull(publicKeyPem);
            return this;
        }

        @CustomType.Setter
        public Builder signingAlgorithms(List<String> signingAlgorithms) {
            this.signingAlgorithms = Objects.requireNonNull(signingAlgorithms);
            return this;
        }

        public Builder signingAlgorithms(String ... signingAlgorithms) {
            return this.signingAlgorithms(List.of(signingAlgorithms));
        }

        public GetPublicKeyResult build() {
            GetPublicKeyResult o = new GetPublicKeyResult();
            o.arn = this.arn;
            o.customerMasterKeySpec = this.customerMasterKeySpec;
            o.encryptionAlgorithms = this.encryptionAlgorithms;
            o.grantTokens = this.grantTokens;
            o.id = this.id;
            o.keyId = this.keyId;
            o.keyUsage = this.keyUsage;
            o.publicKey = this.publicKey;
            o.publicKeyPem = this.publicKeyPem;
            o.signingAlgorithms = this.signingAlgorithms;
            return o;
        }
    }
}

