/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.lambda.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class FunctionUrlCors {
    @Nullable
    private Boolean allowCredentials;
    @Nullable
    private List<String> allowHeaders;
    @Nullable
    private List<String> allowMethods;
    @Nullable
    private List<String> allowOrigins;
    @Nullable
    private List<String> exposeHeaders;
    @Nullable
    private Integer maxAge;

    private FunctionUrlCors() {
    }

    public Optional<Boolean> allowCredentials() {
        return Optional.ofNullable(this.allowCredentials);
    }

    public List<String> allowHeaders() {
        return this.allowHeaders == null ? List.of() : this.allowHeaders;
    }

    public List<String> allowMethods() {
        return this.allowMethods == null ? List.of() : this.allowMethods;
    }

    public List<String> allowOrigins() {
        return this.allowOrigins == null ? List.of() : this.allowOrigins;
    }

    public List<String> exposeHeaders() {
        return this.exposeHeaders == null ? List.of() : this.exposeHeaders;
    }

    public Optional<Integer> maxAge() {
        return Optional.ofNullable(this.maxAge);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FunctionUrlCors defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean allowCredentials;
        @Nullable
        private List<String> allowHeaders;
        @Nullable
        private List<String> allowMethods;
        @Nullable
        private List<String> allowOrigins;
        @Nullable
        private List<String> exposeHeaders;
        @Nullable
        private Integer maxAge;

        public Builder() {
        }

        public Builder(FunctionUrlCors defaults) {
            Objects.requireNonNull(defaults);
            this.allowCredentials = defaults.allowCredentials;
            this.allowHeaders = defaults.allowHeaders;
            this.allowMethods = defaults.allowMethods;
            this.allowOrigins = defaults.allowOrigins;
            this.exposeHeaders = defaults.exposeHeaders;
            this.maxAge = defaults.maxAge;
        }

        @CustomType.Setter
        public Builder allowCredentials(@Nullable Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        @CustomType.Setter
        public Builder allowHeaders(@Nullable List<String> allowHeaders) {
            this.allowHeaders = allowHeaders;
            return this;
        }

        public Builder allowHeaders(String ... allowHeaders) {
            return this.allowHeaders(List.of(allowHeaders));
        }

        @CustomType.Setter
        public Builder allowMethods(@Nullable List<String> allowMethods) {
            this.allowMethods = allowMethods;
            return this;
        }

        public Builder allowMethods(String ... allowMethods) {
            return this.allowMethods(List.of(allowMethods));
        }

        @CustomType.Setter
        public Builder allowOrigins(@Nullable List<String> allowOrigins) {
            this.allowOrigins = allowOrigins;
            return this;
        }

        public Builder allowOrigins(String ... allowOrigins) {
            return this.allowOrigins(List.of(allowOrigins));
        }

        @CustomType.Setter
        public Builder exposeHeaders(@Nullable List<String> exposeHeaders) {
            this.exposeHeaders = exposeHeaders;
            return this;
        }

        public Builder exposeHeaders(String ... exposeHeaders) {
            return this.exposeHeaders(List.of(exposeHeaders));
        }

        @CustomType.Setter
        public Builder maxAge(@Nullable Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public FunctionUrlCors build() {
            FunctionUrlCors o = new FunctionUrlCors();
            o.allowCredentials = this.allowCredentials;
            o.allowHeaders = this.allowHeaders;
            o.allowMethods = this.allowMethods;
            o.allowOrigins = this.allowOrigins;
            o.exposeHeaders = this.exposeHeaders;
            o.maxAge = this.maxAge;
            return o;
        }
    }
}

