/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.lex.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class IntentConfirmationPromptMessage {
    private String content;
    private String contentType;
    @Nullable
    private Integer groupNumber;

    private IntentConfirmationPromptMessage() {
    }

    public String content() {
        return this.content;
    }

    public String contentType() {
        return this.contentType;
    }

    public Optional<Integer> groupNumber() {
        return Optional.ofNullable(this.groupNumber);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IntentConfirmationPromptMessage defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String content;
        private String contentType;
        @Nullable
        private Integer groupNumber;

        public Builder() {
        }

        public Builder(IntentConfirmationPromptMessage defaults) {
            Objects.requireNonNull(defaults);
            this.content = defaults.content;
            this.contentType = defaults.contentType;
            this.groupNumber = defaults.groupNumber;
        }

        @CustomType.Setter
        public Builder content(String content) {
            this.content = Objects.requireNonNull(content);
            return this;
        }

        @CustomType.Setter
        public Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType);
            return this;
        }

        @CustomType.Setter
        public Builder groupNumber(@Nullable Integer groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public IntentConfirmationPromptMessage build() {
            IntentConfirmationPromptMessage o = new IntentConfirmationPromptMessage();
            o.content = this.content;
            o.contentType = this.contentType;
            o.groupNumber = this.groupNumber;
            return o;
        }
    }
}

