/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.memorydb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class UserAuthenticationMode {
    @Nullable
    private Integer passwordCount;
    private List<String> passwords;
    private String type;

    private UserAuthenticationMode() {
    }

    public Optional<Integer> passwordCount() {
        return Optional.ofNullable(this.passwordCount);
    }

    public List<String> passwords() {
        return this.passwords;
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserAuthenticationMode defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer passwordCount;
        private List<String> passwords;
        private String type;

        public Builder() {
        }

        public Builder(UserAuthenticationMode defaults) {
            Objects.requireNonNull(defaults);
            this.passwordCount = defaults.passwordCount;
            this.passwords = defaults.passwords;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder passwordCount(@Nullable Integer passwordCount) {
            this.passwordCount = passwordCount;
            return this;
        }

        @CustomType.Setter
        public Builder passwords(List<String> passwords) {
            this.passwords = Objects.requireNonNull(passwords);
            return this;
        }

        public Builder passwords(String ... passwords) {
            return this.passwords(List.of(passwords));
        }

        @CustomType.Setter
        public Builder type(String type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public UserAuthenticationMode build() {
            UserAuthenticationMode o = new UserAuthenticationMode();
            o.passwordCount = this.passwordCount;
            o.passwords = this.passwords;
            o.type = this.type;
            return o;
        }
    }
}

