/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.mq.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BrokerEncryptionOptions {
    @Nullable
    private String kmsKeyId;
    @Nullable
    private Boolean useAwsOwnedKey;

    private BrokerEncryptionOptions() {
    }

    public Optional<String> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    public Optional<Boolean> useAwsOwnedKey() {
        return Optional.ofNullable(this.useAwsOwnedKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BrokerEncryptionOptions defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String kmsKeyId;
        @Nullable
        private Boolean useAwsOwnedKey;

        public Builder() {
        }

        public Builder(BrokerEncryptionOptions defaults) {
            Objects.requireNonNull(defaults);
            this.kmsKeyId = defaults.kmsKeyId;
            this.useAwsOwnedKey = defaults.useAwsOwnedKey;
        }

        @CustomType.Setter
        public Builder kmsKeyId(@Nullable String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @CustomType.Setter
        public Builder useAwsOwnedKey(@Nullable Boolean useAwsOwnedKey) {
            this.useAwsOwnedKey = useAwsOwnedKey;
            return this;
        }

        public BrokerEncryptionOptions build() {
            BrokerEncryptionOptions o = new BrokerEncryptionOptions();
            o.kmsKeyId = this.kmsKeyId;
            o.useAwsOwnedKey = this.useAwsOwnedKey;
            return o;
        }
    }
}

