/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.mq.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BrokerInstance {
    @Nullable
    private String consoleUrl;
    @Nullable
    private List<String> endpoints;
    @Nullable
    private String ipAddress;

    private BrokerInstance() {
    }

    public Optional<String> consoleUrl() {
        return Optional.ofNullable(this.consoleUrl);
    }

    public List<String> endpoints() {
        return this.endpoints == null ? List.of() : this.endpoints;
    }

    public Optional<String> ipAddress() {
        return Optional.ofNullable(this.ipAddress);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BrokerInstance defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String consoleUrl;
        @Nullable
        private List<String> endpoints;
        @Nullable
        private String ipAddress;

        public Builder() {
        }

        public Builder(BrokerInstance defaults) {
            Objects.requireNonNull(defaults);
            this.consoleUrl = defaults.consoleUrl;
            this.endpoints = defaults.endpoints;
            this.ipAddress = defaults.ipAddress;
        }

        @CustomType.Setter
        public Builder consoleUrl(@Nullable String consoleUrl) {
            this.consoleUrl = consoleUrl;
            return this;
        }

        @CustomType.Setter
        public Builder endpoints(@Nullable List<String> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Builder endpoints(String ... endpoints) {
            return this.endpoints(List.of(endpoints));
        }

        @CustomType.Setter
        public Builder ipAddress(@Nullable String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public BrokerInstance build() {
            BrokerInstance o = new BrokerInstance();
            o.consoleUrl = this.consoleUrl;
            o.endpoints = this.endpoints;
            o.ipAddress = this.ipAddress;
            return o;
        }
    }
}

