/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.msk;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class VpcConnectionArgs
extends ResourceArgs {
    public static final VpcConnectionArgs Empty = new VpcConnectionArgs();
    @Import(name="authentication", required=true)
    private Output<String> authentication;
    @Import(name="clientSubnets", required=true)
    private Output<List<String>> clientSubnets;
    @Import(name="securityGroups", required=true)
    private Output<List<String>> securityGroups;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;
    @Import(name="targetClusterArn", required=true)
    private Output<String> targetClusterArn;
    @Import(name="vpcId", required=true)
    private Output<String> vpcId;

    public Output<String> authentication() {
        return this.authentication;
    }

    public Output<List<String>> clientSubnets() {
        return this.clientSubnets;
    }

    public Output<List<String>> securityGroups() {
        return this.securityGroups;
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    public Output<String> targetClusterArn() {
        return this.targetClusterArn;
    }

    public Output<String> vpcId() {
        return this.vpcId;
    }

    private VpcConnectionArgs() {
    }

    private VpcConnectionArgs(VpcConnectionArgs $) {
        this.authentication = $.authentication;
        this.clientSubnets = $.clientSubnets;
        this.securityGroups = $.securityGroups;
        this.tags = $.tags;
        this.targetClusterArn = $.targetClusterArn;
        this.vpcId = $.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(VpcConnectionArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private VpcConnectionArgs $;

        public Builder() {
            this.$ = new VpcConnectionArgs();
        }

        public Builder(VpcConnectionArgs defaults) {
            this.$ = new VpcConnectionArgs(Objects.requireNonNull(defaults));
        }

        public Builder authentication(Output<String> authentication) {
            this.$.authentication = authentication;
            return this;
        }

        public Builder authentication(String authentication) {
            return this.authentication((Output<String>)Output.of((Object)authentication));
        }

        public Builder clientSubnets(Output<List<String>> clientSubnets) {
            this.$.clientSubnets = clientSubnets;
            return this;
        }

        public Builder clientSubnets(List<String> clientSubnets) {
            return this.clientSubnets((Output<List<String>>)Output.of(clientSubnets));
        }

        public Builder clientSubnets(String ... clientSubnets) {
            return this.clientSubnets(List.of(clientSubnets));
        }

        public Builder securityGroups(Output<List<String>> securityGroups) {
            this.$.securityGroups = securityGroups;
            return this;
        }

        public Builder securityGroups(List<String> securityGroups) {
            return this.securityGroups((Output<List<String>>)Output.of(securityGroups));
        }

        public Builder securityGroups(String ... securityGroups) {
            return this.securityGroups(List.of(securityGroups));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public Builder targetClusterArn(Output<String> targetClusterArn) {
            this.$.targetClusterArn = targetClusterArn;
            return this;
        }

        public Builder targetClusterArn(String targetClusterArn) {
            return this.targetClusterArn((Output<String>)Output.of((Object)targetClusterArn));
        }

        public Builder vpcId(Output<String> vpcId) {
            this.$.vpcId = vpcId;
            return this;
        }

        public Builder vpcId(String vpcId) {
            return this.vpcId((Output<String>)Output.of((Object)vpcId));
        }

        public VpcConnectionArgs build() {
            this.$.authentication = Objects.requireNonNull(this.$.authentication, "expected parameter 'authentication' to be non-null");
            this.$.clientSubnets = Objects.requireNonNull(this.$.clientSubnets, "expected parameter 'clientSubnets' to be non-null");
            this.$.securityGroups = Objects.requireNonNull(this.$.securityGroups, "expected parameter 'securityGroups' to be non-null");
            this.$.targetClusterArn = Objects.requireNonNull(this.$.targetClusterArn, "expected parameter 'targetClusterArn' to be non-null");
            this.$.vpcId = Objects.requireNonNull(this.$.vpcId, "expected parameter 'vpcId' to be non-null");
            return this.$;
        }
    }
}

