/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.mwaa.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class EnvironmentNetworkConfiguration {
    private List<String> securityGroupIds;
    private List<String> subnetIds;

    private EnvironmentNetworkConfiguration() {
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EnvironmentNetworkConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> securityGroupIds;
        private List<String> subnetIds;

        public Builder() {
        }

        public Builder(EnvironmentNetworkConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
        }

        @CustomType.Setter
        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = Objects.requireNonNull(securityGroupIds);
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        public EnvironmentNetworkConfiguration build() {
            EnvironmentNetworkConfiguration o = new EnvironmentNetworkConfiguration();
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            return o;
        }
    }
}

