/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.networkmanager.outputs;

import com.pulumi.aws.networkmanager.outputs.ConnectPeerConfigurationBgpConfiguration;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ConnectPeerConfiguration {
    @Nullable
    private List<ConnectPeerConfigurationBgpConfiguration> bgpConfigurations;
    @Nullable
    private String coreNetworkAddress;
    @Nullable
    private List<String> insideCidrBlocks;
    @Nullable
    private String peerAddress;
    @Nullable
    private String protocol;

    private ConnectPeerConfiguration() {
    }

    public List<ConnectPeerConfigurationBgpConfiguration> bgpConfigurations() {
        return this.bgpConfigurations == null ? List.of() : this.bgpConfigurations;
    }

    public Optional<String> coreNetworkAddress() {
        return Optional.ofNullable(this.coreNetworkAddress);
    }

    public List<String> insideCidrBlocks() {
        return this.insideCidrBlocks == null ? List.of() : this.insideCidrBlocks;
    }

    public Optional<String> peerAddress() {
        return Optional.ofNullable(this.peerAddress);
    }

    public Optional<String> protocol() {
        return Optional.ofNullable(this.protocol);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConnectPeerConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<ConnectPeerConfigurationBgpConfiguration> bgpConfigurations;
        @Nullable
        private String coreNetworkAddress;
        @Nullable
        private List<String> insideCidrBlocks;
        @Nullable
        private String peerAddress;
        @Nullable
        private String protocol;

        public Builder() {
        }

        public Builder(ConnectPeerConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.bgpConfigurations = defaults.bgpConfigurations;
            this.coreNetworkAddress = defaults.coreNetworkAddress;
            this.insideCidrBlocks = defaults.insideCidrBlocks;
            this.peerAddress = defaults.peerAddress;
            this.protocol = defaults.protocol;
        }

        @CustomType.Setter
        public Builder bgpConfigurations(@Nullable List<ConnectPeerConfigurationBgpConfiguration> bgpConfigurations) {
            this.bgpConfigurations = bgpConfigurations;
            return this;
        }

        public Builder bgpConfigurations(ConnectPeerConfigurationBgpConfiguration ... bgpConfigurations) {
            return this.bgpConfigurations(List.of(bgpConfigurations));
        }

        @CustomType.Setter
        public Builder coreNetworkAddress(@Nullable String coreNetworkAddress) {
            this.coreNetworkAddress = coreNetworkAddress;
            return this;
        }

        @CustomType.Setter
        public Builder insideCidrBlocks(@Nullable List<String> insideCidrBlocks) {
            this.insideCidrBlocks = insideCidrBlocks;
            return this;
        }

        public Builder insideCidrBlocks(String ... insideCidrBlocks) {
            return this.insideCidrBlocks(List.of(insideCidrBlocks));
        }

        @CustomType.Setter
        public Builder peerAddress(@Nullable String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        @CustomType.Setter
        public Builder protocol(@Nullable String protocol) {
            this.protocol = protocol;
            return this;
        }

        public ConnectPeerConfiguration build() {
            ConnectPeerConfiguration o = new ConnectPeerConfiguration();
            o.bgpConfigurations = this.bgpConfigurations;
            o.coreNetworkAddress = this.coreNetworkAddress;
            o.insideCidrBlocks = this.insideCidrBlocks;
            o.peerAddress = this.peerAddress;
            o.protocol = this.protocol;
            return o;
        }
    }
}

