/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.opsworks.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ApplicationEnvironment {
    private String key;
    @Nullable
    private Boolean secure;
    private String value;

    private ApplicationEnvironment() {
    }

    public String key() {
        return this.key;
    }

    public Optional<Boolean> secure() {
        return Optional.ofNullable(this.secure);
    }

    public String value() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ApplicationEnvironment defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String key;
        @Nullable
        private Boolean secure;
        private String value;

        public Builder() {
        }

        public Builder(ApplicationEnvironment defaults) {
            Objects.requireNonNull(defaults);
            this.key = defaults.key;
            this.secure = defaults.secure;
            this.value = defaults.value;
        }

        @CustomType.Setter
        public Builder key(String key) {
            this.key = Objects.requireNonNull(key);
            return this;
        }

        @CustomType.Setter
        public Builder secure(@Nullable Boolean secure) {
            this.secure = secure;
            return this;
        }

        @CustomType.Setter
        public Builder value(String value) {
            this.value = Objects.requireNonNull(value);
            return this;
        }

        public ApplicationEnvironment build() {
            ApplicationEnvironment o = new ApplicationEnvironment();
            o.key = this.key;
            o.secure = this.secure;
            o.value = this.value;
            return o;
        }
    }
}

