/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.qldb.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StreamKinesisConfiguration {
    @Nullable
    private Boolean aggregationEnabled;
    private String streamArn;

    private StreamKinesisConfiguration() {
    }

    public Optional<Boolean> aggregationEnabled() {
        return Optional.ofNullable(this.aggregationEnabled);
    }

    public String streamArn() {
        return this.streamArn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreamKinesisConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean aggregationEnabled;
        private String streamArn;

        public Builder() {
        }

        public Builder(StreamKinesisConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.aggregationEnabled = defaults.aggregationEnabled;
            this.streamArn = defaults.streamArn;
        }

        @CustomType.Setter
        public Builder aggregationEnabled(@Nullable Boolean aggregationEnabled) {
            this.aggregationEnabled = aggregationEnabled;
            return this;
        }

        @CustomType.Setter
        public Builder streamArn(String streamArn) {
            this.streamArn = Objects.requireNonNull(streamArn);
            return this;
        }

        public StreamKinesisConfiguration build() {
            StreamKinesisConfiguration o = new StreamKinesisConfiguration();
            o.aggregationEnabled = this.aggregationEnabled;
            o.streamArn = this.streamArn;
            return o;
        }
    }
}

