/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.rds.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterS3Import {
    private String bucketName;
    @Nullable
    private String bucketPrefix;
    private String ingestionRole;
    private String sourceEngine;
    private String sourceEngineVersion;

    private ClusterS3Import() {
    }

    public String bucketName() {
        return this.bucketName;
    }

    public Optional<String> bucketPrefix() {
        return Optional.ofNullable(this.bucketPrefix);
    }

    public String ingestionRole() {
        return this.ingestionRole;
    }

    public String sourceEngine() {
        return this.sourceEngine;
    }

    public String sourceEngineVersion() {
        return this.sourceEngineVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterS3Import defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String bucketName;
        @Nullable
        private String bucketPrefix;
        private String ingestionRole;
        private String sourceEngine;
        private String sourceEngineVersion;

        public Builder() {
        }

        public Builder(ClusterS3Import defaults) {
            Objects.requireNonNull(defaults);
            this.bucketName = defaults.bucketName;
            this.bucketPrefix = defaults.bucketPrefix;
            this.ingestionRole = defaults.ingestionRole;
            this.sourceEngine = defaults.sourceEngine;
            this.sourceEngineVersion = defaults.sourceEngineVersion;
        }

        @CustomType.Setter
        public Builder bucketName(String bucketName) {
            this.bucketName = Objects.requireNonNull(bucketName);
            return this;
        }

        @CustomType.Setter
        public Builder bucketPrefix(@Nullable String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        @CustomType.Setter
        public Builder ingestionRole(String ingestionRole) {
            this.ingestionRole = Objects.requireNonNull(ingestionRole);
            return this;
        }

        @CustomType.Setter
        public Builder sourceEngine(String sourceEngine) {
            this.sourceEngine = Objects.requireNonNull(sourceEngine);
            return this;
        }

        @CustomType.Setter
        public Builder sourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = Objects.requireNonNull(sourceEngineVersion);
            return this;
        }

        public ClusterS3Import build() {
            ClusterS3Import o = new ClusterS3Import();
            o.bucketName = this.bucketName;
            o.bucketPrefix = this.bucketPrefix;
            o.ingestionRole = this.ingestionRole;
            o.sourceEngine = this.sourceEngine;
            o.sourceEngineVersion = this.sourceEngineVersion;
            return o;
        }
    }
}

