/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.redshift.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ClusterLogging {
    @Nullable
    private String bucketName;
    private Boolean enable;
    @Nullable
    private String logDestinationType;
    @Nullable
    private List<String> logExports;
    @Nullable
    private String s3KeyPrefix;

    private ClusterLogging() {
    }

    public Optional<String> bucketName() {
        return Optional.ofNullable(this.bucketName);
    }

    public Boolean enable() {
        return this.enable;
    }

    public Optional<String> logDestinationType() {
        return Optional.ofNullable(this.logDestinationType);
    }

    public List<String> logExports() {
        return this.logExports == null ? List.of() : this.logExports;
    }

    public Optional<String> s3KeyPrefix() {
        return Optional.ofNullable(this.s3KeyPrefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterLogging defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String bucketName;
        private Boolean enable;
        @Nullable
        private String logDestinationType;
        @Nullable
        private List<String> logExports;
        @Nullable
        private String s3KeyPrefix;

        public Builder() {
        }

        public Builder(ClusterLogging defaults) {
            Objects.requireNonNull(defaults);
            this.bucketName = defaults.bucketName;
            this.enable = defaults.enable;
            this.logDestinationType = defaults.logDestinationType;
            this.logExports = defaults.logExports;
            this.s3KeyPrefix = defaults.s3KeyPrefix;
        }

        @CustomType.Setter
        public Builder bucketName(@Nullable String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        @CustomType.Setter
        public Builder enable(Boolean enable) {
            this.enable = Objects.requireNonNull(enable);
            return this;
        }

        @CustomType.Setter
        public Builder logDestinationType(@Nullable String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @CustomType.Setter
        public Builder logExports(@Nullable List<String> logExports) {
            this.logExports = logExports;
            return this;
        }

        public Builder logExports(String ... logExports) {
            return this.logExports(List.of(logExports));
        }

        @CustomType.Setter
        public Builder s3KeyPrefix(@Nullable String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public ClusterLogging build() {
            ClusterLogging o = new ClusterLogging();
            o.bucketName = this.bucketName;
            o.enable = this.enable;
            o.logDestinationType = this.logDestinationType;
            o.logExports = this.logExports;
            o.s3KeyPrefix = this.s3KeyPrefix;
            return o;
        }
    }
}

