/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.route53.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetZoneResult {
    private String arn;
    private String callerReference;
    private String comment;
    private String id;
    private String linkedServiceDescription;
    private String linkedServicePrincipal;
    private String name;
    private List<String> nameServers;
    private String primaryNameServer;
    @Nullable
    private Boolean privateZone;
    private Integer resourceRecordSetCount;
    private Map<String, String> tags;
    private String vpcId;
    private String zoneId;

    private GetZoneResult() {
    }

    public String arn() {
        return this.arn;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public String comment() {
        return this.comment;
    }

    public String id() {
        return this.id;
    }

    public String linkedServiceDescription() {
        return this.linkedServiceDescription;
    }

    public String linkedServicePrincipal() {
        return this.linkedServicePrincipal;
    }

    public String name() {
        return this.name;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public String primaryNameServer() {
        return this.primaryNameServer;
    }

    public Optional<Boolean> privateZone() {
        return Optional.ofNullable(this.privateZone);
    }

    public Integer resourceRecordSetCount() {
        return this.resourceRecordSetCount;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String zoneId() {
        return this.zoneId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetZoneResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String arn;
        private String callerReference;
        private String comment;
        private String id;
        private String linkedServiceDescription;
        private String linkedServicePrincipal;
        private String name;
        private List<String> nameServers;
        private String primaryNameServer;
        @Nullable
        private Boolean privateZone;
        private Integer resourceRecordSetCount;
        private Map<String, String> tags;
        private String vpcId;
        private String zoneId;

        public Builder() {
        }

        public Builder(GetZoneResult defaults) {
            Objects.requireNonNull(defaults);
            this.arn = defaults.arn;
            this.callerReference = defaults.callerReference;
            this.comment = defaults.comment;
            this.id = defaults.id;
            this.linkedServiceDescription = defaults.linkedServiceDescription;
            this.linkedServicePrincipal = defaults.linkedServicePrincipal;
            this.name = defaults.name;
            this.nameServers = defaults.nameServers;
            this.primaryNameServer = defaults.primaryNameServer;
            this.privateZone = defaults.privateZone;
            this.resourceRecordSetCount = defaults.resourceRecordSetCount;
            this.tags = defaults.tags;
            this.vpcId = defaults.vpcId;
            this.zoneId = defaults.zoneId;
        }

        @CustomType.Setter
        public Builder arn(String arn) {
            this.arn = Objects.requireNonNull(arn);
            return this;
        }

        @CustomType.Setter
        public Builder callerReference(String callerReference) {
            this.callerReference = Objects.requireNonNull(callerReference);
            return this;
        }

        @CustomType.Setter
        public Builder comment(String comment) {
            this.comment = Objects.requireNonNull(comment);
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder linkedServiceDescription(String linkedServiceDescription) {
            this.linkedServiceDescription = Objects.requireNonNull(linkedServiceDescription);
            return this;
        }

        @CustomType.Setter
        public Builder linkedServicePrincipal(String linkedServicePrincipal) {
            this.linkedServicePrincipal = Objects.requireNonNull(linkedServicePrincipal);
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder nameServers(List<String> nameServers) {
            this.nameServers = Objects.requireNonNull(nameServers);
            return this;
        }

        public Builder nameServers(String ... nameServers) {
            return this.nameServers(List.of(nameServers));
        }

        @CustomType.Setter
        public Builder primaryNameServer(String primaryNameServer) {
            this.primaryNameServer = Objects.requireNonNull(primaryNameServer);
            return this;
        }

        @CustomType.Setter
        public Builder privateZone(@Nullable Boolean privateZone) {
            this.privateZone = privateZone;
            return this;
        }

        @CustomType.Setter
        public Builder resourceRecordSetCount(Integer resourceRecordSetCount) {
            this.resourceRecordSetCount = Objects.requireNonNull(resourceRecordSetCount);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder vpcId(String vpcId) {
            this.vpcId = Objects.requireNonNull(vpcId);
            return this;
        }

        @CustomType.Setter
        public Builder zoneId(String zoneId) {
            this.zoneId = Objects.requireNonNull(zoneId);
            return this;
        }

        public GetZoneResult build() {
            GetZoneResult o = new GetZoneResult();
            o.arn = this.arn;
            o.callerReference = this.callerReference;
            o.comment = this.comment;
            o.id = this.id;
            o.linkedServiceDescription = this.linkedServiceDescription;
            o.linkedServicePrincipal = this.linkedServicePrincipal;
            o.name = this.name;
            o.nameServers = this.nameServers;
            o.primaryNameServer = this.primaryNameServer;
            o.privateZone = this.privateZone;
            o.resourceRecordSetCount = this.resourceRecordSetCount;
            o.tags = this.tags;
            o.vpcId = this.vpcId;
            o.zoneId = this.zoneId;
            return o;
        }
    }
}

