/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.rum.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class AppMonitorAppMonitorConfiguration {
    @Nullable
    private Boolean allowCookies;
    @Nullable
    private Boolean enableXray;
    @Nullable
    private List<String> excludedPages;
    @Nullable
    private List<String> favoritePages;
    @Nullable
    private String guestRoleArn;
    @Nullable
    private String identityPoolId;
    @Nullable
    private List<String> includedPages;
    @Nullable
    private Double sessionSampleRate;
    @Nullable
    private List<String> telemetries;

    private AppMonitorAppMonitorConfiguration() {
    }

    public Optional<Boolean> allowCookies() {
        return Optional.ofNullable(this.allowCookies);
    }

    public Optional<Boolean> enableXray() {
        return Optional.ofNullable(this.enableXray);
    }

    public List<String> excludedPages() {
        return this.excludedPages == null ? List.of() : this.excludedPages;
    }

    public List<String> favoritePages() {
        return this.favoritePages == null ? List.of() : this.favoritePages;
    }

    public Optional<String> guestRoleArn() {
        return Optional.ofNullable(this.guestRoleArn);
    }

    public Optional<String> identityPoolId() {
        return Optional.ofNullable(this.identityPoolId);
    }

    public List<String> includedPages() {
        return this.includedPages == null ? List.of() : this.includedPages;
    }

    public Optional<Double> sessionSampleRate() {
        return Optional.ofNullable(this.sessionSampleRate);
    }

    public List<String> telemetries() {
        return this.telemetries == null ? List.of() : this.telemetries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AppMonitorAppMonitorConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean allowCookies;
        @Nullable
        private Boolean enableXray;
        @Nullable
        private List<String> excludedPages;
        @Nullable
        private List<String> favoritePages;
        @Nullable
        private String guestRoleArn;
        @Nullable
        private String identityPoolId;
        @Nullable
        private List<String> includedPages;
        @Nullable
        private Double sessionSampleRate;
        @Nullable
        private List<String> telemetries;

        public Builder() {
        }

        public Builder(AppMonitorAppMonitorConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.allowCookies = defaults.allowCookies;
            this.enableXray = defaults.enableXray;
            this.excludedPages = defaults.excludedPages;
            this.favoritePages = defaults.favoritePages;
            this.guestRoleArn = defaults.guestRoleArn;
            this.identityPoolId = defaults.identityPoolId;
            this.includedPages = defaults.includedPages;
            this.sessionSampleRate = defaults.sessionSampleRate;
            this.telemetries = defaults.telemetries;
        }

        @CustomType.Setter
        public Builder allowCookies(@Nullable Boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }

        @CustomType.Setter
        public Builder enableXray(@Nullable Boolean enableXray) {
            this.enableXray = enableXray;
            return this;
        }

        @CustomType.Setter
        public Builder excludedPages(@Nullable List<String> excludedPages) {
            this.excludedPages = excludedPages;
            return this;
        }

        public Builder excludedPages(String ... excludedPages) {
            return this.excludedPages(List.of(excludedPages));
        }

        @CustomType.Setter
        public Builder favoritePages(@Nullable List<String> favoritePages) {
            this.favoritePages = favoritePages;
            return this;
        }

        public Builder favoritePages(String ... favoritePages) {
            return this.favoritePages(List.of(favoritePages));
        }

        @CustomType.Setter
        public Builder guestRoleArn(@Nullable String guestRoleArn) {
            this.guestRoleArn = guestRoleArn;
            return this;
        }

        @CustomType.Setter
        public Builder identityPoolId(@Nullable String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        @CustomType.Setter
        public Builder includedPages(@Nullable List<String> includedPages) {
            this.includedPages = includedPages;
            return this;
        }

        public Builder includedPages(String ... includedPages) {
            return this.includedPages(List.of(includedPages));
        }

        @CustomType.Setter
        public Builder sessionSampleRate(@Nullable Double sessionSampleRate) {
            this.sessionSampleRate = sessionSampleRate;
            return this;
        }

        @CustomType.Setter
        public Builder telemetries(@Nullable List<String> telemetries) {
            this.telemetries = telemetries;
            return this;
        }

        public Builder telemetries(String ... telemetries) {
            return this.telemetries(List.of(telemetries));
        }

        public AppMonitorAppMonitorConfiguration build() {
            AppMonitorAppMonitorConfiguration o = new AppMonitorAppMonitorConfiguration();
            o.allowCookies = this.allowCookies;
            o.enableXray = this.enableXray;
            o.excludedPages = this.excludedPages;
            o.favoritePages = this.favoritePages;
            o.guestRoleArn = this.guestRoleArn;
            o.identityPoolId = this.identityPoolId;
            o.includedPages = this.includedPages;
            o.sessionSampleRate = this.sessionSampleRate;
            o.telemetries = this.telemetries;
            return o;
        }
    }
}

