/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3;

import com.pulumi.aws.s3.inputs.BucketNotificationLambdaFunctionArgs;
import com.pulumi.aws.s3.inputs.BucketNotificationQueueArgs;
import com.pulumi.aws.s3.inputs.BucketNotificationTopicArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BucketNotificationArgs
extends ResourceArgs {
    public static final BucketNotificationArgs Empty = new BucketNotificationArgs();
    @Import(name="bucket", required=true)
    private Output<String> bucket;
    @Import(name="eventbridge")
    @Nullable
    private Output<Boolean> eventbridge;
    @Import(name="lambdaFunctions")
    @Nullable
    private Output<List<BucketNotificationLambdaFunctionArgs>> lambdaFunctions;
    @Import(name="queues")
    @Nullable
    private Output<List<BucketNotificationQueueArgs>> queues;
    @Import(name="topics")
    @Nullable
    private Output<List<BucketNotificationTopicArgs>> topics;

    public Output<String> bucket() {
        return this.bucket;
    }

    public Optional<Output<Boolean>> eventbridge() {
        return Optional.ofNullable(this.eventbridge);
    }

    public Optional<Output<List<BucketNotificationLambdaFunctionArgs>>> lambdaFunctions() {
        return Optional.ofNullable(this.lambdaFunctions);
    }

    public Optional<Output<List<BucketNotificationQueueArgs>>> queues() {
        return Optional.ofNullable(this.queues);
    }

    public Optional<Output<List<BucketNotificationTopicArgs>>> topics() {
        return Optional.ofNullable(this.topics);
    }

    private BucketNotificationArgs() {
    }

    private BucketNotificationArgs(BucketNotificationArgs $) {
        this.bucket = $.bucket;
        this.eventbridge = $.eventbridge;
        this.lambdaFunctions = $.lambdaFunctions;
        this.queues = $.queues;
        this.topics = $.topics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketNotificationArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private BucketNotificationArgs $;

        public Builder() {
            this.$ = new BucketNotificationArgs();
        }

        public Builder(BucketNotificationArgs defaults) {
            this.$ = new BucketNotificationArgs(Objects.requireNonNull(defaults));
        }

        public Builder bucket(Output<String> bucket) {
            this.$.bucket = bucket;
            return this;
        }

        public Builder bucket(String bucket) {
            return this.bucket((Output<String>)Output.of((Object)bucket));
        }

        public Builder eventbridge(@Nullable Output<Boolean> eventbridge) {
            this.$.eventbridge = eventbridge;
            return this;
        }

        public Builder eventbridge(Boolean eventbridge) {
            return this.eventbridge((Output<Boolean>)Output.of((Object)eventbridge));
        }

        public Builder lambdaFunctions(@Nullable Output<List<BucketNotificationLambdaFunctionArgs>> lambdaFunctions) {
            this.$.lambdaFunctions = lambdaFunctions;
            return this;
        }

        public Builder lambdaFunctions(List<BucketNotificationLambdaFunctionArgs> lambdaFunctions) {
            return this.lambdaFunctions((Output<List<BucketNotificationLambdaFunctionArgs>>)Output.of(lambdaFunctions));
        }

        public Builder lambdaFunctions(BucketNotificationLambdaFunctionArgs ... lambdaFunctions) {
            return this.lambdaFunctions(List.of(lambdaFunctions));
        }

        public Builder queues(@Nullable Output<List<BucketNotificationQueueArgs>> queues) {
            this.$.queues = queues;
            return this;
        }

        public Builder queues(List<BucketNotificationQueueArgs> queues) {
            return this.queues((Output<List<BucketNotificationQueueArgs>>)Output.of(queues));
        }

        public Builder queues(BucketNotificationQueueArgs ... queues) {
            return this.queues(List.of(queues));
        }

        public Builder topics(@Nullable Output<List<BucketNotificationTopicArgs>> topics) {
            this.$.topics = topics;
            return this;
        }

        public Builder topics(List<BucketNotificationTopicArgs> topics) {
            return this.topics((Output<List<BucketNotificationTopicArgs>>)Output.of(topics));
        }

        public Builder topics(BucketNotificationTopicArgs ... topics) {
            return this.topics(List.of(topics));
        }

        public BucketNotificationArgs build() {
            this.$.bucket = Objects.requireNonNull(this.$.bucket, "expected parameter 'bucket' to be non-null");
            return this.$;
        }
    }
}

