/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3;

import com.pulumi.aws.Utilities;
import com.pulumi.aws.s3.InventoryArgs;
import com.pulumi.aws.s3.inputs.InventoryState;
import com.pulumi.aws.s3.outputs.InventoryDestination;
import com.pulumi.aws.s3.outputs.InventoryFilter;
import com.pulumi.aws.s3.outputs.InventorySchedule;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.resources.CustomResource;
import com.pulumi.resources.CustomResourceOptions;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

@ResourceType(type="aws:s3/inventory:Inventory")
public class Inventory
extends CustomResource {
    @Export(name="bucket", refs={String.class}, tree="[0]")
    private Output<String> bucket;
    @Export(name="destination", refs={InventoryDestination.class}, tree="[0]")
    private Output<InventoryDestination> destination;
    @Export(name="enabled", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> enabled;
    @Export(name="filter", refs={InventoryFilter.class}, tree="[0]")
    private Output<InventoryFilter> filter;
    @Export(name="includedObjectVersions", refs={String.class}, tree="[0]")
    private Output<String> includedObjectVersions;
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;
    @Export(name="optionalFields", refs={List.class, String.class}, tree="[0,1]")
    private Output<List<String>> optionalFields;
    @Export(name="schedule", refs={InventorySchedule.class}, tree="[0]")
    private Output<InventorySchedule> schedule;

    public Output<String> bucket() {
        return this.bucket;
    }

    public Output<InventoryDestination> destination() {
        return this.destination;
    }

    public Output<Optional<Boolean>> enabled() {
        return Codegen.optional(this.enabled);
    }

    public Output<Optional<InventoryFilter>> filter() {
        return Codegen.optional(this.filter);
    }

    public Output<String> includedObjectVersions() {
        return this.includedObjectVersions;
    }

    public Output<String> name() {
        return this.name;
    }

    public Output<Optional<List<String>>> optionalFields() {
        return Codegen.optional(this.optionalFields);
    }

    public Output<InventorySchedule> schedule() {
        return this.schedule;
    }

    public Inventory(String name) {
        this(name, InventoryArgs.Empty);
    }

    public Inventory(String name, InventoryArgs args) {
        this(name, args, null);
    }

    public Inventory(String name, InventoryArgs args, @Nullable CustomResourceOptions options) {
        super("aws:s3/inventory:Inventory", name, (ResourceArgs)(args == null ? InventoryArgs.Empty : args), Inventory.makeResourceOptions(options, (Output<String>)Codegen.empty()));
    }

    private Inventory(String name, Output<String> id, @Nullable InventoryState state, @Nullable CustomResourceOptions options) {
        super("aws:s3/inventory:Inventory", name, (ResourceArgs)state, Inventory.makeResourceOptions(options, id));
    }

    private static CustomResourceOptions makeResourceOptions(@Nullable CustomResourceOptions options, @Nullable Output<String> id) {
        CustomResourceOptions defaultOptions = ((CustomResourceOptions.Builder)CustomResourceOptions.builder().version(Utilities.getVersion())).build();
        return CustomResourceOptions.merge((CustomResourceOptions)defaultOptions, (CustomResourceOptions)options, id);
    }

    public static Inventory get(String name, Output<String> id, @Nullable InventoryState state, @Nullable CustomResourceOptions options) {
        return new Inventory(name, id, state, options);
    }
}

