/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BucketLogging {
    private String targetBucket;
    @Nullable
    private String targetPrefix;

    private BucketLogging() {
    }

    public String targetBucket() {
        return this.targetBucket;
    }

    public Optional<String> targetPrefix() {
        return Optional.ofNullable(this.targetPrefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketLogging defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String targetBucket;
        @Nullable
        private String targetPrefix;

        public Builder() {
        }

        public Builder(BucketLogging defaults) {
            Objects.requireNonNull(defaults);
            this.targetBucket = defaults.targetBucket;
            this.targetPrefix = defaults.targetPrefix;
        }

        @CustomType.Setter
        public Builder targetBucket(String targetBucket) {
            this.targetBucket = Objects.requireNonNull(targetBucket);
            return this;
        }

        @CustomType.Setter
        public Builder targetPrefix(@Nullable String targetPrefix) {
            this.targetPrefix = targetPrefix;
            return this;
        }

        public BucketLogging build() {
            BucketLogging o = new BucketLogging();
            o.targetBucket = this.targetBucket;
            o.targetPrefix = this.targetPrefix;
            return o;
        }
    }
}

