/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class BucketNotificationTopic {
    private List<String> events;
    @Nullable
    private String filterPrefix;
    @Nullable
    private String filterSuffix;
    @Nullable
    private String id;
    private String topicArn;

    private BucketNotificationTopic() {
    }

    public List<String> events() {
        return this.events;
    }

    public Optional<String> filterPrefix() {
        return Optional.ofNullable(this.filterPrefix);
    }

    public Optional<String> filterSuffix() {
        return Optional.ofNullable(this.filterSuffix);
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public String topicArn() {
        return this.topicArn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketNotificationTopic defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> events;
        @Nullable
        private String filterPrefix;
        @Nullable
        private String filterSuffix;
        @Nullable
        private String id;
        private String topicArn;

        public Builder() {
        }

        public Builder(BucketNotificationTopic defaults) {
            Objects.requireNonNull(defaults);
            this.events = defaults.events;
            this.filterPrefix = defaults.filterPrefix;
            this.filterSuffix = defaults.filterSuffix;
            this.id = defaults.id;
            this.topicArn = defaults.topicArn;
        }

        @CustomType.Setter
        public Builder events(List<String> events) {
            this.events = Objects.requireNonNull(events);
            return this;
        }

        public Builder events(String ... events) {
            return this.events(List.of(events));
        }

        @CustomType.Setter
        public Builder filterPrefix(@Nullable String filterPrefix) {
            this.filterPrefix = filterPrefix;
            return this;
        }

        @CustomType.Setter
        public Builder filterSuffix(@Nullable String filterSuffix) {
            this.filterSuffix = filterSuffix;
            return this;
        }

        @CustomType.Setter
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @CustomType.Setter
        public Builder topicArn(String topicArn) {
            this.topicArn = Objects.requireNonNull(topicArn);
            return this;
        }

        public BucketNotificationTopic build() {
            BucketNotificationTopic o = new BucketNotificationTopic();
            o.events = this.events;
            o.filterPrefix = this.filterPrefix;
            o.filterSuffix = this.filterSuffix;
            o.id = this.id;
            o.topicArn = this.topicArn;
            return o;
        }
    }
}

