/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.aws.s3.outputs.BucketReplicationConfigurationRule;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class BucketReplicationConfiguration {
    private String role;
    private List<BucketReplicationConfigurationRule> rules;

    private BucketReplicationConfiguration() {
    }

    public String role() {
        return this.role;
    }

    public List<BucketReplicationConfigurationRule> rules() {
        return this.rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketReplicationConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String role;
        private List<BucketReplicationConfigurationRule> rules;

        public Builder() {
        }

        public Builder(BucketReplicationConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.role = defaults.role;
            this.rules = defaults.rules;
        }

        @CustomType.Setter
        public Builder role(String role) {
            this.role = Objects.requireNonNull(role);
            return this;
        }

        @CustomType.Setter
        public Builder rules(List<BucketReplicationConfigurationRule> rules) {
            this.rules = Objects.requireNonNull(rules);
            return this;
        }

        public Builder rules(BucketReplicationConfigurationRule ... rules) {
            return this.rules(List.of(rules));
        }

        public BucketReplicationConfiguration build() {
            BucketReplicationConfiguration o = new BucketReplicationConfiguration();
            o.role = this.role;
            o.rules = this.rules;
            return o;
        }
    }
}

