/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.aws.s3.outputs.BucketV2ReplicationConfigurationRule;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class BucketV2ReplicationConfiguration {
    private String role;
    private List<BucketV2ReplicationConfigurationRule> rules;

    private BucketV2ReplicationConfiguration() {
    }

    public String role() {
        return this.role;
    }

    public List<BucketV2ReplicationConfigurationRule> rules() {
        return this.rules;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BucketV2ReplicationConfiguration defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String role;
        private List<BucketV2ReplicationConfigurationRule> rules;

        public Builder() {
        }

        public Builder(BucketV2ReplicationConfiguration defaults) {
            Objects.requireNonNull(defaults);
            this.role = defaults.role;
            this.rules = defaults.rules;
        }

        @CustomType.Setter
        public Builder role(String role) {
            this.role = Objects.requireNonNull(role);
            return this;
        }

        @CustomType.Setter
        public Builder rules(List<BucketV2ReplicationConfigurationRule> rules) {
            this.rules = Objects.requireNonNull(rules);
            return this;
        }

        public Builder rules(BucketV2ReplicationConfigurationRule ... rules) {
            return this.rules(List.of(rules));
        }

        public BucketV2ReplicationConfiguration build() {
            BucketV2ReplicationConfiguration o = new BucketV2ReplicationConfiguration();
            o.role = this.role;
            o.rules = this.rules;
            return o;
        }
    }
}

