/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GetObjectResult {
    private String body;
    private String bucket;
    private Boolean bucketKeyEnabled;
    private String cacheControl;
    private String checksumCrc32;
    private String checksumCrc32c;
    @Nullable
    private String checksumMode;
    private String checksumSha1;
    private String checksumSha256;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private Integer contentLength;
    private String contentType;
    private String etag;
    private String expiration;
    private String expires;
    private String id;
    private String key;
    private String lastModified;
    private Map<String, String> metadata;
    private String objectLockLegalHoldStatus;
    private String objectLockMode;
    private String objectLockRetainUntilDate;
    @Nullable
    private String range;
    private String serverSideEncryption;
    private String sseKmsKeyId;
    private String storageClass;
    private Map<String, String> tags;
    private String versionId;
    private String websiteRedirectLocation;

    private GetObjectResult() {
    }

    public String body() {
        return this.body;
    }

    public String bucket() {
        return this.bucket;
    }

    public Boolean bucketKeyEnabled() {
        return this.bucketKeyEnabled;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String checksumCrc32() {
        return this.checksumCrc32;
    }

    public String checksumCrc32c() {
        return this.checksumCrc32c;
    }

    public Optional<String> checksumMode() {
        return Optional.ofNullable(this.checksumMode);
    }

    public String checksumSha1() {
        return this.checksumSha1;
    }

    public String checksumSha256() {
        return this.checksumSha256;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public Integer contentLength() {
        return this.contentLength;
    }

    public String contentType() {
        return this.contentType;
    }

    public String etag() {
        return this.etag;
    }

    public String expiration() {
        return this.expiration;
    }

    public String expires() {
        return this.expires;
    }

    public String id() {
        return this.id;
    }

    public String key() {
        return this.key;
    }

    public String lastModified() {
        return this.lastModified;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public String objectLockLegalHoldStatus() {
        return this.objectLockLegalHoldStatus;
    }

    public String objectLockMode() {
        return this.objectLockMode;
    }

    public String objectLockRetainUntilDate() {
        return this.objectLockRetainUntilDate;
    }

    public Optional<String> range() {
        return Optional.ofNullable(this.range);
    }

    public String serverSideEncryption() {
        return this.serverSideEncryption;
    }

    public String sseKmsKeyId() {
        return this.sseKmsKeyId;
    }

    public String storageClass() {
        return this.storageClass;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String versionId() {
        return this.versionId;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GetObjectResult defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String body;
        private String bucket;
        private Boolean bucketKeyEnabled;
        private String cacheControl;
        private String checksumCrc32;
        private String checksumCrc32c;
        @Nullable
        private String checksumMode;
        private String checksumSha1;
        private String checksumSha256;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private Integer contentLength;
        private String contentType;
        private String etag;
        private String expiration;
        private String expires;
        private String id;
        private String key;
        private String lastModified;
        private Map<String, String> metadata;
        private String objectLockLegalHoldStatus;
        private String objectLockMode;
        private String objectLockRetainUntilDate;
        @Nullable
        private String range;
        private String serverSideEncryption;
        private String sseKmsKeyId;
        private String storageClass;
        private Map<String, String> tags;
        private String versionId;
        private String websiteRedirectLocation;

        public Builder() {
        }

        public Builder(GetObjectResult defaults) {
            Objects.requireNonNull(defaults);
            this.body = defaults.body;
            this.bucket = defaults.bucket;
            this.bucketKeyEnabled = defaults.bucketKeyEnabled;
            this.cacheControl = defaults.cacheControl;
            this.checksumCrc32 = defaults.checksumCrc32;
            this.checksumCrc32c = defaults.checksumCrc32c;
            this.checksumMode = defaults.checksumMode;
            this.checksumSha1 = defaults.checksumSha1;
            this.checksumSha256 = defaults.checksumSha256;
            this.contentDisposition = defaults.contentDisposition;
            this.contentEncoding = defaults.contentEncoding;
            this.contentLanguage = defaults.contentLanguage;
            this.contentLength = defaults.contentLength;
            this.contentType = defaults.contentType;
            this.etag = defaults.etag;
            this.expiration = defaults.expiration;
            this.expires = defaults.expires;
            this.id = defaults.id;
            this.key = defaults.key;
            this.lastModified = defaults.lastModified;
            this.metadata = defaults.metadata;
            this.objectLockLegalHoldStatus = defaults.objectLockLegalHoldStatus;
            this.objectLockMode = defaults.objectLockMode;
            this.objectLockRetainUntilDate = defaults.objectLockRetainUntilDate;
            this.range = defaults.range;
            this.serverSideEncryption = defaults.serverSideEncryption;
            this.sseKmsKeyId = defaults.sseKmsKeyId;
            this.storageClass = defaults.storageClass;
            this.tags = defaults.tags;
            this.versionId = defaults.versionId;
            this.websiteRedirectLocation = defaults.websiteRedirectLocation;
        }

        @CustomType.Setter
        public Builder body(String body) {
            this.body = Objects.requireNonNull(body);
            return this;
        }

        @CustomType.Setter
        public Builder bucket(String bucket) {
            this.bucket = Objects.requireNonNull(bucket);
            return this;
        }

        @CustomType.Setter
        public Builder bucketKeyEnabled(Boolean bucketKeyEnabled) {
            this.bucketKeyEnabled = Objects.requireNonNull(bucketKeyEnabled);
            return this;
        }

        @CustomType.Setter
        public Builder cacheControl(String cacheControl) {
            this.cacheControl = Objects.requireNonNull(cacheControl);
            return this;
        }

        @CustomType.Setter
        public Builder checksumCrc32(String checksumCrc32) {
            this.checksumCrc32 = Objects.requireNonNull(checksumCrc32);
            return this;
        }

        @CustomType.Setter
        public Builder checksumCrc32c(String checksumCrc32c) {
            this.checksumCrc32c = Objects.requireNonNull(checksumCrc32c);
            return this;
        }

        @CustomType.Setter
        public Builder checksumMode(@Nullable String checksumMode) {
            this.checksumMode = checksumMode;
            return this;
        }

        @CustomType.Setter
        public Builder checksumSha1(String checksumSha1) {
            this.checksumSha1 = Objects.requireNonNull(checksumSha1);
            return this;
        }

        @CustomType.Setter
        public Builder checksumSha256(String checksumSha256) {
            this.checksumSha256 = Objects.requireNonNull(checksumSha256);
            return this;
        }

        @CustomType.Setter
        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = Objects.requireNonNull(contentDisposition);
            return this;
        }

        @CustomType.Setter
        public Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = Objects.requireNonNull(contentEncoding);
            return this;
        }

        @CustomType.Setter
        public Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = Objects.requireNonNull(contentLanguage);
            return this;
        }

        @CustomType.Setter
        public Builder contentLength(Integer contentLength) {
            this.contentLength = Objects.requireNonNull(contentLength);
            return this;
        }

        @CustomType.Setter
        public Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType);
            return this;
        }

        @CustomType.Setter
        public Builder etag(String etag) {
            this.etag = Objects.requireNonNull(etag);
            return this;
        }

        @CustomType.Setter
        public Builder expiration(String expiration) {
            this.expiration = Objects.requireNonNull(expiration);
            return this;
        }

        @CustomType.Setter
        public Builder expires(String expires) {
            this.expires = Objects.requireNonNull(expires);
            return this;
        }

        @CustomType.Setter
        public Builder id(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        @CustomType.Setter
        public Builder key(String key) {
            this.key = Objects.requireNonNull(key);
            return this;
        }

        @CustomType.Setter
        public Builder lastModified(String lastModified) {
            this.lastModified = Objects.requireNonNull(lastModified);
            return this;
        }

        @CustomType.Setter
        public Builder metadata(Map<String, String> metadata) {
            this.metadata = Objects.requireNonNull(metadata);
            return this;
        }

        @CustomType.Setter
        public Builder objectLockLegalHoldStatus(String objectLockLegalHoldStatus) {
            this.objectLockLegalHoldStatus = Objects.requireNonNull(objectLockLegalHoldStatus);
            return this;
        }

        @CustomType.Setter
        public Builder objectLockMode(String objectLockMode) {
            this.objectLockMode = Objects.requireNonNull(objectLockMode);
            return this;
        }

        @CustomType.Setter
        public Builder objectLockRetainUntilDate(String objectLockRetainUntilDate) {
            this.objectLockRetainUntilDate = Objects.requireNonNull(objectLockRetainUntilDate);
            return this;
        }

        @CustomType.Setter
        public Builder range(@Nullable String range) {
            this.range = range;
            return this;
        }

        @CustomType.Setter
        public Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = Objects.requireNonNull(serverSideEncryption);
            return this;
        }

        @CustomType.Setter
        public Builder sseKmsKeyId(String sseKmsKeyId) {
            this.sseKmsKeyId = Objects.requireNonNull(sseKmsKeyId);
            return this;
        }

        @CustomType.Setter
        public Builder storageClass(String storageClass) {
            this.storageClass = Objects.requireNonNull(storageClass);
            return this;
        }

        @CustomType.Setter
        public Builder tags(Map<String, String> tags) {
            this.tags = Objects.requireNonNull(tags);
            return this;
        }

        @CustomType.Setter
        public Builder versionId(String versionId) {
            this.versionId = Objects.requireNonNull(versionId);
            return this;
        }

        @CustomType.Setter
        public Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = Objects.requireNonNull(websiteRedirectLocation);
            return this;
        }

        public GetObjectResult build() {
            GetObjectResult o = new GetObjectResult();
            o.body = this.body;
            o.bucket = this.bucket;
            o.bucketKeyEnabled = this.bucketKeyEnabled;
            o.cacheControl = this.cacheControl;
            o.checksumCrc32 = this.checksumCrc32;
            o.checksumCrc32c = this.checksumCrc32c;
            o.checksumMode = this.checksumMode;
            o.checksumSha1 = this.checksumSha1;
            o.checksumSha256 = this.checksumSha256;
            o.contentDisposition = this.contentDisposition;
            o.contentEncoding = this.contentEncoding;
            o.contentLanguage = this.contentLanguage;
            o.contentLength = this.contentLength;
            o.contentType = this.contentType;
            o.etag = this.etag;
            o.expiration = this.expiration;
            o.expires = this.expires;
            o.id = this.id;
            o.key = this.key;
            o.lastModified = this.lastModified;
            o.metadata = this.metadata;
            o.objectLockLegalHoldStatus = this.objectLockLegalHoldStatus;
            o.objectLockMode = this.objectLockMode;
            o.objectLockRetainUntilDate = this.objectLockRetainUntilDate;
            o.range = this.range;
            o.serverSideEncryption = this.serverSideEncryption;
            o.sseKmsKeyId = this.sseKmsKeyId;
            o.storageClass = this.storageClass;
            o.tags = this.tags;
            o.versionId = this.versionId;
            o.websiteRedirectLocation = this.websiteRedirectLocation;
            return o;
        }
    }
}

