/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.s3.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ObjectCopyGrant {
    @Nullable
    private String email;
    @Nullable
    private String id;
    private List<String> permissions;
    private String type;
    @Nullable
    private String uri;

    private ObjectCopyGrant() {
    }

    public Optional<String> email() {
        return Optional.ofNullable(this.email);
    }

    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    public List<String> permissions() {
        return this.permissions;
    }

    public String type() {
        return this.type;
    }

    public Optional<String> uri() {
        return Optional.ofNullable(this.uri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ObjectCopyGrant defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String email;
        @Nullable
        private String id;
        private List<String> permissions;
        private String type;
        @Nullable
        private String uri;

        public Builder() {
        }

        public Builder(ObjectCopyGrant defaults) {
            Objects.requireNonNull(defaults);
            this.email = defaults.email;
            this.id = defaults.id;
            this.permissions = defaults.permissions;
            this.type = defaults.type;
            this.uri = defaults.uri;
        }

        @CustomType.Setter
        public Builder email(@Nullable String email) {
            this.email = email;
            return this;
        }

        @CustomType.Setter
        public Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @CustomType.Setter
        public Builder permissions(List<String> permissions) {
            this.permissions = Objects.requireNonNull(permissions);
            return this;
        }

        public Builder permissions(String ... permissions) {
            return this.permissions(List.of(permissions));
        }

        @CustomType.Setter
        public Builder type(String type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        @CustomType.Setter
        public Builder uri(@Nullable String uri) {
            this.uri = uri;
            return this;
        }

        public ObjectCopyGrant build() {
            ObjectCopyGrant o = new ObjectCopyGrant();
            o.email = this.email;
            o.id = this.id;
            o.permissions = this.permissions;
            o.type = this.type;
            o.uri = this.uri;
            return o;
        }
    }
}

