/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.sagemaker.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class DeviceFleetOutputConfig {
    @Nullable
    private String kmsKeyId;
    private String s3OutputLocation;

    private DeviceFleetOutputConfig() {
    }

    public Optional<String> kmsKeyId() {
        return Optional.ofNullable(this.kmsKeyId);
    }

    public String s3OutputLocation() {
        return this.s3OutputLocation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DeviceFleetOutputConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String kmsKeyId;
        private String s3OutputLocation;

        public Builder() {
        }

        public Builder(DeviceFleetOutputConfig defaults) {
            Objects.requireNonNull(defaults);
            this.kmsKeyId = defaults.kmsKeyId;
            this.s3OutputLocation = defaults.s3OutputLocation;
        }

        @CustomType.Setter
        public Builder kmsKeyId(@Nullable String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @CustomType.Setter
        public Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = Objects.requireNonNull(s3OutputLocation);
            return this;
        }

        public DeviceFleetOutputConfig build() {
            DeviceFleetOutputConfig o = new DeviceFleetOutputConfig();
            o.kmsKeyId = this.kmsKeyId;
            o.s3OutputLocation = this.s3OutputLocation;
            return o;
        }
    }
}

