/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.serverlessrepository;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.resources.ResourceArgs;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class CloudFormationStackArgs
extends ResourceArgs {
    public static final CloudFormationStackArgs Empty = new CloudFormationStackArgs();
    @Import(name="applicationId", required=true)
    private Output<String> applicationId;
    @Import(name="capabilities", required=true)
    private Output<List<String>> capabilities;
    @Import(name="name")
    @Nullable
    private Output<String> name;
    @Import(name="parameters")
    @Nullable
    private Output<Map<String, String>> parameters;
    @Import(name="semanticVersion")
    @Nullable
    private Output<String> semanticVersion;
    @Import(name="tags")
    @Nullable
    private Output<Map<String, String>> tags;

    public Output<String> applicationId() {
        return this.applicationId;
    }

    public Output<List<String>> capabilities() {
        return this.capabilities;
    }

    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Output<Map<String, String>>> parameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<Output<String>> semanticVersion() {
        return Optional.ofNullable(this.semanticVersion);
    }

    public Optional<Output<Map<String, String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    private CloudFormationStackArgs() {
    }

    private CloudFormationStackArgs(CloudFormationStackArgs $) {
        this.applicationId = $.applicationId;
        this.capabilities = $.capabilities;
        this.name = $.name;
        this.parameters = $.parameters;
        this.semanticVersion = $.semanticVersion;
        this.tags = $.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CloudFormationStackArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private CloudFormationStackArgs $;

        public Builder() {
            this.$ = new CloudFormationStackArgs();
        }

        public Builder(CloudFormationStackArgs defaults) {
            this.$ = new CloudFormationStackArgs(Objects.requireNonNull(defaults));
        }

        public Builder applicationId(Output<String> applicationId) {
            this.$.applicationId = applicationId;
            return this;
        }

        public Builder applicationId(String applicationId) {
            return this.applicationId((Output<String>)Output.of((Object)applicationId));
        }

        public Builder capabilities(Output<List<String>> capabilities) {
            this.$.capabilities = capabilities;
            return this;
        }

        public Builder capabilities(List<String> capabilities) {
            return this.capabilities((Output<List<String>>)Output.of(capabilities));
        }

        public Builder capabilities(String ... capabilities) {
            return this.capabilities(List.of(capabilities));
        }

        public Builder name(@Nullable Output<String> name) {
            this.$.name = name;
            return this;
        }

        public Builder name(String name) {
            return this.name((Output<String>)Output.of((Object)name));
        }

        public Builder parameters(@Nullable Output<Map<String, String>> parameters) {
            this.$.parameters = parameters;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            return this.parameters((Output<Map<String, String>>)Output.of(parameters));
        }

        public Builder semanticVersion(@Nullable Output<String> semanticVersion) {
            this.$.semanticVersion = semanticVersion;
            return this;
        }

        public Builder semanticVersion(String semanticVersion) {
            return this.semanticVersion((Output<String>)Output.of((Object)semanticVersion));
        }

        public Builder tags(@Nullable Output<Map<String, String>> tags) {
            this.$.tags = tags;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            return this.tags((Output<Map<String, String>>)Output.of(tags));
        }

        public CloudFormationStackArgs build() {
            this.$.applicationId = Objects.requireNonNull(this.$.applicationId, "expected parameter 'applicationId' to be non-null");
            this.$.capabilities = Objects.requireNonNull(this.$.capabilities, "expected parameter 'capabilities' to be non-null");
            return this.$;
        }
    }
}

