/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.storagegateway.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class GatewaySmbActiveDirectorySettings {
    @Nullable
    private String activeDirectoryStatus;
    @Nullable
    private List<String> domainControllers;
    private String domainName;
    @Nullable
    private String organizationalUnit;
    private String password;
    @Nullable
    private Integer timeoutInSeconds;
    private String username;

    private GatewaySmbActiveDirectorySettings() {
    }

    public Optional<String> activeDirectoryStatus() {
        return Optional.ofNullable(this.activeDirectoryStatus);
    }

    public List<String> domainControllers() {
        return this.domainControllers == null ? List.of() : this.domainControllers;
    }

    public String domainName() {
        return this.domainName;
    }

    public Optional<String> organizationalUnit() {
        return Optional.ofNullable(this.organizationalUnit);
    }

    public String password() {
        return this.password;
    }

    public Optional<Integer> timeoutInSeconds() {
        return Optional.ofNullable(this.timeoutInSeconds);
    }

    public String username() {
        return this.username;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(GatewaySmbActiveDirectorySettings defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String activeDirectoryStatus;
        @Nullable
        private List<String> domainControllers;
        private String domainName;
        @Nullable
        private String organizationalUnit;
        private String password;
        @Nullable
        private Integer timeoutInSeconds;
        private String username;

        public Builder() {
        }

        public Builder(GatewaySmbActiveDirectorySettings defaults) {
            Objects.requireNonNull(defaults);
            this.activeDirectoryStatus = defaults.activeDirectoryStatus;
            this.domainControllers = defaults.domainControllers;
            this.domainName = defaults.domainName;
            this.organizationalUnit = defaults.organizationalUnit;
            this.password = defaults.password;
            this.timeoutInSeconds = defaults.timeoutInSeconds;
            this.username = defaults.username;
        }

        @CustomType.Setter
        public Builder activeDirectoryStatus(@Nullable String activeDirectoryStatus) {
            this.activeDirectoryStatus = activeDirectoryStatus;
            return this;
        }

        @CustomType.Setter
        public Builder domainControllers(@Nullable List<String> domainControllers) {
            this.domainControllers = domainControllers;
            return this;
        }

        public Builder domainControllers(String ... domainControllers) {
            return this.domainControllers(List.of(domainControllers));
        }

        @CustomType.Setter
        public Builder domainName(String domainName) {
            this.domainName = Objects.requireNonNull(domainName);
            return this;
        }

        @CustomType.Setter
        public Builder organizationalUnit(@Nullable String organizationalUnit) {
            this.organizationalUnit = organizationalUnit;
            return this;
        }

        @CustomType.Setter
        public Builder password(String password) {
            this.password = Objects.requireNonNull(password);
            return this;
        }

        @CustomType.Setter
        public Builder timeoutInSeconds(@Nullable Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        @CustomType.Setter
        public Builder username(String username) {
            this.username = Objects.requireNonNull(username);
            return this;
        }

        public GatewaySmbActiveDirectorySettings build() {
            GatewaySmbActiveDirectorySettings o = new GatewaySmbActiveDirectorySettings();
            o.activeDirectoryStatus = this.activeDirectoryStatus;
            o.domainControllers = this.domainControllers;
            o.domainName = this.domainName;
            o.organizationalUnit = this.organizationalUnit;
            o.password = this.password;
            o.timeoutInSeconds = this.timeoutInSeconds;
            o.username = this.username;
            return o;
        }
    }
}

