/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.synthetics.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CanaryRunConfig {
    @Nullable
    private Boolean activeTracing;
    @Nullable
    private Map<String, String> environmentVariables;
    @Nullable
    private Integer memoryInMb;
    @Nullable
    private Integer timeoutInSeconds;

    private CanaryRunConfig() {
    }

    public Optional<Boolean> activeTracing() {
        return Optional.ofNullable(this.activeTracing);
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables == null ? Map.of() : this.environmentVariables;
    }

    public Optional<Integer> memoryInMb() {
        return Optional.ofNullable(this.memoryInMb);
    }

    public Optional<Integer> timeoutInSeconds() {
        return Optional.ofNullable(this.timeoutInSeconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CanaryRunConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Boolean activeTracing;
        @Nullable
        private Map<String, String> environmentVariables;
        @Nullable
        private Integer memoryInMb;
        @Nullable
        private Integer timeoutInSeconds;

        public Builder() {
        }

        public Builder(CanaryRunConfig defaults) {
            Objects.requireNonNull(defaults);
            this.activeTracing = defaults.activeTracing;
            this.environmentVariables = defaults.environmentVariables;
            this.memoryInMb = defaults.memoryInMb;
            this.timeoutInSeconds = defaults.timeoutInSeconds;
        }

        @CustomType.Setter
        public Builder activeTracing(@Nullable Boolean activeTracing) {
            this.activeTracing = activeTracing;
            return this;
        }

        @CustomType.Setter
        public Builder environmentVariables(@Nullable Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        @CustomType.Setter
        public Builder memoryInMb(@Nullable Integer memoryInMb) {
            this.memoryInMb = memoryInMb;
            return this;
        }

        @CustomType.Setter
        public Builder timeoutInSeconds(@Nullable Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public CanaryRunConfig build() {
            CanaryRunConfig o = new CanaryRunConfig();
            o.activeTracing = this.activeTracing;
            o.environmentVariables = this.environmentVariables;
            o.memoryInMb = this.memoryInMb;
            o.timeoutInSeconds = this.timeoutInSeconds;
            return o;
        }
    }
}

