/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.transcribe.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class LanguageModelInputDataConfig {
    private String dataAccessRoleArn;
    private String s3Uri;
    @Nullable
    private String tuningDataS3Uri;

    private LanguageModelInputDataConfig() {
    }

    public String dataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public String s3Uri() {
        return this.s3Uri;
    }

    public Optional<String> tuningDataS3Uri() {
        return Optional.ofNullable(this.tuningDataS3Uri);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LanguageModelInputDataConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String dataAccessRoleArn;
        private String s3Uri;
        @Nullable
        private String tuningDataS3Uri;

        public Builder() {
        }

        public Builder(LanguageModelInputDataConfig defaults) {
            Objects.requireNonNull(defaults);
            this.dataAccessRoleArn = defaults.dataAccessRoleArn;
            this.s3Uri = defaults.s3Uri;
            this.tuningDataS3Uri = defaults.tuningDataS3Uri;
        }

        @CustomType.Setter
        public Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = Objects.requireNonNull(dataAccessRoleArn);
            return this;
        }

        @CustomType.Setter
        public Builder s3Uri(String s3Uri) {
            this.s3Uri = Objects.requireNonNull(s3Uri);
            return this;
        }

        @CustomType.Setter
        public Builder tuningDataS3Uri(@Nullable String tuningDataS3Uri) {
            this.tuningDataS3Uri = tuningDataS3Uri;
            return this;
        }

        public LanguageModelInputDataConfig build() {
            LanguageModelInputDataConfig o = new LanguageModelInputDataConfig();
            o.dataAccessRoleArn = this.dataAccessRoleArn;
            o.s3Uri = this.s3Uri;
            o.tuningDataS3Uri = this.tuningDataS3Uri;
            return o;
        }
    }
}

