/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.wafv2.outputs;

import com.pulumi.aws.wafv2.outputs.WebAclRuleAction;
import com.pulumi.aws.wafv2.outputs.WebAclRuleCaptchaConfig;
import com.pulumi.aws.wafv2.outputs.WebAclRuleOverrideAction;
import com.pulumi.aws.wafv2.outputs.WebAclRuleRuleLabel;
import com.pulumi.aws.wafv2.outputs.WebAclRuleStatement;
import com.pulumi.aws.wafv2.outputs.WebAclRuleVisibilityConfig;
import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class WebAclRule {
    @Nullable
    private WebAclRuleAction action;
    @Nullable
    private WebAclRuleCaptchaConfig captchaConfig;
    private String name;
    @Nullable
    private WebAclRuleOverrideAction overrideAction;
    private Integer priority;
    @Nullable
    private List<WebAclRuleRuleLabel> ruleLabels;
    private WebAclRuleStatement statement;
    private WebAclRuleVisibilityConfig visibilityConfig;

    private WebAclRule() {
    }

    public Optional<WebAclRuleAction> action() {
        return Optional.ofNullable(this.action);
    }

    public Optional<WebAclRuleCaptchaConfig> captchaConfig() {
        return Optional.ofNullable(this.captchaConfig);
    }

    public String name() {
        return this.name;
    }

    public Optional<WebAclRuleOverrideAction> overrideAction() {
        return Optional.ofNullable(this.overrideAction);
    }

    public Integer priority() {
        return this.priority;
    }

    public List<WebAclRuleRuleLabel> ruleLabels() {
        return this.ruleLabels == null ? List.of() : this.ruleLabels;
    }

    public WebAclRuleStatement statement() {
        return this.statement;
    }

    public WebAclRuleVisibilityConfig visibilityConfig() {
        return this.visibilityConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebAclRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private WebAclRuleAction action;
        @Nullable
        private WebAclRuleCaptchaConfig captchaConfig;
        private String name;
        @Nullable
        private WebAclRuleOverrideAction overrideAction;
        private Integer priority;
        @Nullable
        private List<WebAclRuleRuleLabel> ruleLabels;
        private WebAclRuleStatement statement;
        private WebAclRuleVisibilityConfig visibilityConfig;

        public Builder() {
        }

        public Builder(WebAclRule defaults) {
            Objects.requireNonNull(defaults);
            this.action = defaults.action;
            this.captchaConfig = defaults.captchaConfig;
            this.name = defaults.name;
            this.overrideAction = defaults.overrideAction;
            this.priority = defaults.priority;
            this.ruleLabels = defaults.ruleLabels;
            this.statement = defaults.statement;
            this.visibilityConfig = defaults.visibilityConfig;
        }

        @CustomType.Setter
        public Builder action(@Nullable WebAclRuleAction action) {
            this.action = action;
            return this;
        }

        @CustomType.Setter
        public Builder captchaConfig(@Nullable WebAclRuleCaptchaConfig captchaConfig) {
            this.captchaConfig = captchaConfig;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder overrideAction(@Nullable WebAclRuleOverrideAction overrideAction) {
            this.overrideAction = overrideAction;
            return this;
        }

        @CustomType.Setter
        public Builder priority(Integer priority) {
            this.priority = Objects.requireNonNull(priority);
            return this;
        }

        @CustomType.Setter
        public Builder ruleLabels(@Nullable List<WebAclRuleRuleLabel> ruleLabels) {
            this.ruleLabels = ruleLabels;
            return this;
        }

        public Builder ruleLabels(WebAclRuleRuleLabel ... ruleLabels) {
            return this.ruleLabels(List.of(ruleLabels));
        }

        @CustomType.Setter
        public Builder statement(WebAclRuleStatement statement) {
            this.statement = Objects.requireNonNull(statement);
            return this;
        }

        @CustomType.Setter
        public Builder visibilityConfig(WebAclRuleVisibilityConfig visibilityConfig) {
            this.visibilityConfig = Objects.requireNonNull(visibilityConfig);
            return this;
        }

        public WebAclRule build() {
            WebAclRule o = new WebAclRule();
            o.action = this.action;
            o.captchaConfig = this.captchaConfig;
            o.name = this.name;
            o.overrideAction = this.overrideAction;
            o.priority = this.priority;
            o.ruleLabels = this.ruleLabels;
            o.statement = this.statement;
            o.visibilityConfig = this.visibilityConfig;
            return o;
        }
    }
}

