/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.aws.worklink.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class FleetNetwork {
    private List<String> securityGroupIds;
    private List<String> subnetIds;
    private String vpcId;

    private FleetNetwork() {
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FleetNetwork defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> securityGroupIds;
        private List<String> subnetIds;
        private String vpcId;

        public Builder() {
        }

        public Builder(FleetNetwork defaults) {
            Objects.requireNonNull(defaults);
            this.securityGroupIds = defaults.securityGroupIds;
            this.subnetIds = defaults.subnetIds;
            this.vpcId = defaults.vpcId;
        }

        @CustomType.Setter
        public Builder securityGroupIds(List<String> securityGroupIds) {
            this.securityGroupIds = Objects.requireNonNull(securityGroupIds);
            return this;
        }

        public Builder securityGroupIds(String ... securityGroupIds) {
            return this.securityGroupIds(List.of(securityGroupIds));
        }

        @CustomType.Setter
        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = Objects.requireNonNull(subnetIds);
            return this;
        }

        public Builder subnetIds(String ... subnetIds) {
            return this.subnetIds(List.of(subnetIds));
        }

        @CustomType.Setter
        public Builder vpcId(String vpcId) {
            this.vpcId = Objects.requireNonNull(vpcId);
            return this;
        }

        public FleetNetwork build() {
            FleetNetwork o = new FleetNetwork();
            o.securityGroupIds = this.securityGroupIds;
            o.subnetIds = this.subnetIds;
            o.vpcId = this.vpcId;
            return o;
        }
    }
}

