// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.cloudamqp;

import com.pulumi.cloudamqp.CustomDomainArgs;
import com.pulumi.cloudamqp.Utilities;
import com.pulumi.cloudamqp.inputs.CustomDomainState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * This resource allows you to configure and manage your custom domain for the CloudAMQP instance.
 * 
 * Adding a custom domain to your instance will generate a TLS certificate from [Let&#39;s Encrypt], for the given hostname, and install it on all servers in your cluster. The certificate will be automatically renewed going forward.
 * 
 * &gt; **WARNING:** Please note that when creating, changing or deleting the custom domain, the listeners on your servers will be restarted in order to apply the changes. This will close your current connections.
 * 
 * Your custom domain name needs to point to your CloudAMQP hostname, preferably using a CNAME DNS record.
 * 
 * Only available for dedicated subscription plans.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.CustomDomain;
 * import com.pulumi.cloudamqp.CustomDomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var settings = new CustomDomain(&#34;settings&#34;, CustomDomainArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .hostname(&#34;myname.mydomain&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ## Depedency
 * 
 * This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.
 * 
 * ## Import
 * 
 * `cloudamqp_custom_domain` can be imported using CloudAMQP instance identifier.
 * 
 * ```sh
 *  $ pulumi import cloudamqp:index/customDomain:CustomDomain settings &lt;instance_id&gt;`
 * ```
 * 
 *  [Let&#39;s Encrypt]https://letsencrypt.org/
 * 
 */
@ResourceType(type="cloudamqp:index/customDomain:CustomDomain")
public class CustomDomain extends com.pulumi.resources.CustomResource {
    /**
     * Your custom domain name.
     * 
     */
    @Export(name="hostname", refs={String.class}, tree="[0]")
    private Output<String> hostname;

    /**
     * @return Your custom domain name.
     * 
     */
    public Output<String> hostname() {
        return this.hostname;
    }
    /**
     * The CloudAMQP instance ID.
     * 
     */
    @Export(name="instanceId", refs={Integer.class}, tree="[0]")
    private Output<Integer> instanceId;

    /**
     * @return The CloudAMQP instance ID.
     * 
     */
    public Output<Integer> instanceId() {
        return this.instanceId;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public CustomDomain(String name) {
        this(name, CustomDomainArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public CustomDomain(String name, CustomDomainArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public CustomDomain(String name, CustomDomainArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/customDomain:CustomDomain", name, args == null ? CustomDomainArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private CustomDomain(String name, Output<String> id, @Nullable CustomDomainState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/customDomain:CustomDomain", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static CustomDomain get(String name, Output<String> id, @Nullable CustomDomainState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new CustomDomain(name, id, state, options);
    }
}
