// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.cloudamqp;

import com.pulumi.cloudamqp.ExtraDiskSizeArgs;
import com.pulumi.cloudamqp.Utilities;
import com.pulumi.cloudamqp.inputs.ExtraDiskSizeState;
import com.pulumi.cloudamqp.outputs.ExtraDiskSizeNode;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * This resource allows you to resize the disk with additional storage capacity.
 * 
 * ***Pre v1.25.0***: Only available for Amazon Web Services (AWS) and it done without downtime
 * 
 * ***Post v1.25.0***: Now also available for Google Compute Engine (GCE) and Azure.
 * 
 * Introducing a new optional argument called `allow_downtime`.  Leaving it out or set it to false will proceed to try and resize the disk without downtime, available for *AWS* and *GCE*.
 * While *Azure* only support swapping the disk, and this argument needs to be set to *true*.
 * 
 * `allow_downtime` also makes it possible to circumvent the time rate limit or shrinking the disk.
 * 
 * | Cloud Platform        | allow_downtime=false | allow_downtime=true           |
 * |-----------------------|----------------------|-------------------------------|
 * | amazon-web-services   | Expand current disk* | Try to expand, otherwise swap |
 * | google-compute-engine | Expand current disk* | Try to expand, otherwise swap |
 * | azure-arm             | Not supported        | Swap disk to new size         |
 * 
 * *Preferable method to use.
 * 
 * &gt; **WARNING:** Due to restrictions from cloud providers, it&#39;s only possible to resize the disk every 8 hours. Unless the `allow_downtime=true` is set, then the disk will be swapped for a new.
 * 
 * Pricing is available at [cloudamqp.com](https://www.cloudamqp.com/) and only available for dedicated subscription plans.
 * 
 * ## Example Usage
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;AWS extra disk size (pre v1.25.0)&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.Instance;
 * import com.pulumi.cloudamqp.InstanceArgs;
 * import com.pulumi.cloudamqp.ExtraDiskSize;
 * import com.pulumi.cloudamqp.ExtraDiskSizeArgs;
 * import com.pulumi.cloudamqp.CloudamqpFunctions;
 * import com.pulumi.cloudamqp.inputs.GetNodesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var instance = new Instance(&#34;instance&#34;, InstanceArgs.builder()        
 *             .plan(&#34;bunny-1&#34;)
 *             .region(&#34;amazon-web-services::us-west-2&#34;)
 *             .build());
 * 
 *         var resizeDisk = new ExtraDiskSize(&#34;resizeDisk&#34;, ExtraDiskSizeArgs.builder()        
 *             .instanceId(instance.id())
 *             .extraDiskSize(25)
 *             .build());
 * 
 *         final var nodes = CloudamqpFunctions.getNodes(GetNodesArgs.builder()
 *             .instanceId(instance.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * &lt;/details&gt;
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;AWS extra disk size without downtime&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.Instance;
 * import com.pulumi.cloudamqp.InstanceArgs;
 * import com.pulumi.cloudamqp.ExtraDiskSize;
 * import com.pulumi.cloudamqp.ExtraDiskSizeArgs;
 * import com.pulumi.cloudamqp.CloudamqpFunctions;
 * import com.pulumi.cloudamqp.inputs.GetNodesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var instance = new Instance(&#34;instance&#34;, InstanceArgs.builder()        
 *             .plan(&#34;bunny-1&#34;)
 *             .region(&#34;amazon-web-services::us-west-2&#34;)
 *             .build());
 * 
 *         var resizeDisk = new ExtraDiskSize(&#34;resizeDisk&#34;, ExtraDiskSizeArgs.builder()        
 *             .instanceId(instance.id())
 *             .extraDiskSize(25)
 *             .build());
 * 
 *         final var nodes = CloudamqpFunctions.getNodes(GetNodesArgs.builder()
 *             .instanceId(instance.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * &lt;/details&gt;
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;GCE extra disk size without downtime&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.Instance;
 * import com.pulumi.cloudamqp.InstanceArgs;
 * import com.pulumi.cloudamqp.ExtraDiskSize;
 * import com.pulumi.cloudamqp.ExtraDiskSizeArgs;
 * import com.pulumi.cloudamqp.CloudamqpFunctions;
 * import com.pulumi.cloudamqp.inputs.GetNodesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var instance = new Instance(&#34;instance&#34;, InstanceArgs.builder()        
 *             .plan(&#34;bunny-1&#34;)
 *             .region(&#34;google-compute-engine::us-central1&#34;)
 *             .build());
 * 
 *         var resizeDisk = new ExtraDiskSize(&#34;resizeDisk&#34;, ExtraDiskSizeArgs.builder()        
 *             .instanceId(instance.id())
 *             .extraDiskSize(25)
 *             .build());
 * 
 *         final var nodes = CloudamqpFunctions.getNodes(GetNodesArgs.builder()
 *             .instanceId(instance.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * &lt;/details&gt;
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;Azure extra disk size with downtime&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.Instance;
 * import com.pulumi.cloudamqp.InstanceArgs;
 * import com.pulumi.cloudamqp.ExtraDiskSize;
 * import com.pulumi.cloudamqp.ExtraDiskSizeArgs;
 * import com.pulumi.cloudamqp.CloudamqpFunctions;
 * import com.pulumi.cloudamqp.inputs.GetNodesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var instance = new Instance(&#34;instance&#34;, InstanceArgs.builder()        
 *             .plan(&#34;bunny-1&#34;)
 *             .region(&#34;azure-arm::centralus&#34;)
 *             .build());
 * 
 *         var resizeDisk = new ExtraDiskSize(&#34;resizeDisk&#34;, ExtraDiskSizeArgs.builder()        
 *             .instanceId(instance.id())
 *             .extraDiskSize(25)
 *             .allowDowntime(true)
 *             .build());
 * 
 *         final var nodes = CloudamqpFunctions.getNodes(GetNodesArgs.builder()
 *             .instanceId(instance.id())
 *             .build());
 * 
 *     }
 * }
 * ```
 * 
 * &lt;/details&gt;
 * ## Attributes reference
 * 
 * All attributes reference are computed
 * 
 * * `id`    - The identifier for this resource.
 * * `nodes` - An array of node information. Each `nodes` block consists of the fields documented below.
 * 
 * ***
 * 
 * The `nodes` block consist of
 * 
 * * `name`                  - Name of the node.
 * * `disk_size`             - Subscription plan disk size
 * * `additional_disk_size`  - Additional added disk size
 * 
 * ***Note:*** *Total disk size = disk_size + additional_disk_size*
 * 
 * ## Dependency
 * 
 * This data source depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.
 * 
 * ## Import
 * 
 * Not possible to import this resource.
 * 
 */
@ResourceType(type="cloudamqp:index/extraDiskSize:ExtraDiskSize")
public class ExtraDiskSize extends com.pulumi.resources.CustomResource {
    /**
     * When resizing the disk, allow cluster downtime if necessary. Default set to false. Required when hosting in *Azure*.
     * 
     */
    @Export(name="allowDowntime", refs={Boolean.class}, tree="[0]")
    private Output</* @Nullable */ Boolean> allowDowntime;

    /**
     * @return When resizing the disk, allow cluster downtime if necessary. Default set to false. Required when hosting in *Azure*.
     * 
     */
    public Output<Optional<Boolean>> allowDowntime() {
        return Codegen.optional(this.allowDowntime);
    }
    /**
     * Extra disk size in GB. Supported values: 0, 25, 50, 100, 250, 500, 1000, 2000
     * 
     */
    @Export(name="extraDiskSize", refs={Integer.class}, tree="[0]")
    private Output<Integer> extraDiskSize;

    /**
     * @return Extra disk size in GB. Supported values: 0, 25, 50, 100, 250, 500, 1000, 2000
     * 
     */
    public Output<Integer> extraDiskSize() {
        return this.extraDiskSize;
    }
    /**
     * The CloudAMQP instance ID.
     * 
     */
    @Export(name="instanceId", refs={Integer.class}, tree="[0]")
    private Output<Integer> instanceId;

    /**
     * @return The CloudAMQP instance ID.
     * 
     */
    public Output<Integer> instanceId() {
        return this.instanceId;
    }
    @Export(name="nodes", refs={List.class,ExtraDiskSizeNode.class}, tree="[0,1]")
    private Output<List<ExtraDiskSizeNode>> nodes;

    public Output<List<ExtraDiskSizeNode>> nodes() {
        return this.nodes;
    }
    /**
     * Configurable sleep time in seconds between retries for resizing the disk. Default set to 30 seconds.
     * 
     */
    @Export(name="sleep", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> sleep;

    /**
     * @return Configurable sleep time in seconds between retries for resizing the disk. Default set to 30 seconds.
     * 
     */
    public Output<Optional<Integer>> sleep() {
        return Codegen.optional(this.sleep);
    }
    /**
     * Configurable timeout time in seconds for resizing the disk. Default set to 1800 seconds.
     * 
     * ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from v1.25.0.
     * 
     */
    @Export(name="timeout", refs={Integer.class}, tree="[0]")
    private Output</* @Nullable */ Integer> timeout;

    /**
     * @return Configurable timeout time in seconds for resizing the disk. Default set to 1800 seconds.
     * 
     * ***Note:*** `allow_downtime`, `sleep`, `timeout` only available from v1.25.0.
     * 
     */
    public Output<Optional<Integer>> timeout() {
        return Codegen.optional(this.timeout);
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public ExtraDiskSize(String name) {
        this(name, ExtraDiskSizeArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public ExtraDiskSize(String name, ExtraDiskSizeArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public ExtraDiskSize(String name, ExtraDiskSizeArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/extraDiskSize:ExtraDiskSize", name, args == null ? ExtraDiskSizeArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private ExtraDiskSize(String name, Output<String> id, @Nullable ExtraDiskSizeState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/extraDiskSize:ExtraDiskSize", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static ExtraDiskSize get(String name, Output<String> id, @Nullable ExtraDiskSizeState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new ExtraDiskSize(name, id, state, options);
    }
}
