// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.cloudamqp;

import com.pulumi.cloudamqp.NodeActionsArgs;
import com.pulumi.cloudamqp.Utilities;
import com.pulumi.cloudamqp.inputs.NodeActionsState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * This resource allows you to invoke actions on a specific node.
 * 
 * Only available for dedicated subscription plans.
 * 
 * ## Example Usage
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;Already know the node identifier (e.g. from state file)&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.NodeActions;
 * import com.pulumi.cloudamqp.NodeActionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var nodeAction = new NodeActions(&#34;nodeAction&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .nodeName(&#34;&lt;node name&gt;&#34;)
 *             .action(&#34;restart&#34;)
 *             .build());
 * 
 *     }
 * }
 * ```
 * &lt;/details&gt;
 * 
 * Using data source `cloudamqp.getNodes` to restart RabbitMQ on all nodes.&lt;/br&gt;
 * ***Note: RabbitMQ restart on multiple nodes need to be chained, so one node restart at the time.***
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;Multi node RabbitMQ restart&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.CloudamqpFunctions;
 * import com.pulumi.cloudamqp.inputs.GetNodesArgs;
 * import com.pulumi.cloudamqp.NodeActions;
 * import com.pulumi.cloudamqp.NodeActionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var listNodes = CloudamqpFunctions.getNodes(GetNodesArgs.builder()
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .build());
 * 
 *         var restart01 = new NodeActions(&#34;restart01&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .action(&#34;restart&#34;)
 *             .nodeName(listNodes.applyValue(getNodesResult -&gt; getNodesResult.nodes()[0].name()))
 *             .build());
 * 
 *         var restart02 = new NodeActions(&#34;restart02&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .action(&#34;restart&#34;)
 *             .nodeName(listNodes.applyValue(getNodesResult -&gt; getNodesResult.nodes()[1].name()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(restart01)
 *                 .build());
 * 
 *         var restart03 = new NodeActions(&#34;restart03&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .action(&#34;restart&#34;)
 *             .nodeName(listNodes.applyValue(getNodesResult -&gt; getNodesResult.nodes()[2].name()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(                
 *                     restart01,
 *                     restart02)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * &lt;/details&gt;
 * 
 * &lt;details&gt;
 *   &lt;summary&gt;
 *     &lt;b&gt;
 *       &lt;i&gt;Combine log level configuration change with multi node RabbitMQ restart&lt;/i&gt;
 *     &lt;/b&gt;
 *   &lt;/summary&gt;
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.CloudamqpFunctions;
 * import com.pulumi.cloudamqp.inputs.GetNodesArgs;
 * import com.pulumi.cloudamqp.RabbitConfiguration;
 * import com.pulumi.cloudamqp.RabbitConfigurationArgs;
 * import com.pulumi.cloudamqp.NodeActions;
 * import com.pulumi.cloudamqp.NodeActionsArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         final var listNodes = CloudamqpFunctions.getNodes(GetNodesArgs.builder()
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .build());
 * 
 *         var rabbitmqConfig = new RabbitConfiguration(&#34;rabbitmqConfig&#34;, RabbitConfigurationArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .logExchangeLevel(&#34;info&#34;)
 *             .build());
 * 
 *         var restart01 = new NodeActions(&#34;restart01&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .action(&#34;restart&#34;)
 *             .nodeName(listNodes.applyValue(getNodesResult -&gt; getNodesResult.nodes()[0].name()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(rabbitmqConfig)
 *                 .build());
 * 
 *         var restart02 = new NodeActions(&#34;restart02&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .action(&#34;restart&#34;)
 *             .nodeName(listNodes.applyValue(getNodesResult -&gt; getNodesResult.nodes()[1].name()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(                
 *                     rabbitmqConfig,
 *                     restart01)
 *                 .build());
 * 
 *         var restart03 = new NodeActions(&#34;restart03&#34;, NodeActionsArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .action(&#34;restart&#34;)
 *             .nodeName(listNodes.applyValue(getNodesResult -&gt; getNodesResult.nodes()[2].name()))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(                
 *                     rabbitmqConfig,
 *                     restart01,
 *                     restart02)
 *                 .build());
 * 
 *     }
 * }
 * ```
 * &lt;/details&gt;
 * ## Action reference
 * 
 * Valid options for action.
 * 
 * | Action       | Info                               |
 * |--------------|------------------------------------|
 * | start        | Start RabbitMQ                     |
 * | stop         | Stop RabbitMQ                      |
 * | restart      | Restart RabbitMQ                   |
 * | reboot       | Reboot the node                    |
 * | mgmt.restart | Restart the RabbitMQ mgmt interace |
 * 
 * ## Dependency
 * 
 * This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id` and node name.
 * 
 * ## Import
 * 
 * This resource cannot be imported.
 * 
 */
@ResourceType(type="cloudamqp:index/nodeActions:NodeActions")
public class NodeActions extends com.pulumi.resources.CustomResource {
    /**
     * The action to invoke on the node.
     * 
     */
    @Export(name="action", refs={String.class}, tree="[0]")
    private Output<String> action;

    /**
     * @return The action to invoke on the node.
     * 
     */
    public Output<String> action() {
        return this.action;
    }
    /**
     * The CloudAMQP instance ID.
     * 
     */
    @Export(name="instanceId", refs={Integer.class}, tree="[0]")
    private Output<Integer> instanceId;

    /**
     * @return The CloudAMQP instance ID.
     * 
     */
    public Output<Integer> instanceId() {
        return this.instanceId;
    }
    /**
     * The node name, e.g `green-guinea-pig-01`.
     * 
     */
    @Export(name="nodeName", refs={String.class}, tree="[0]")
    private Output<String> nodeName;

    /**
     * @return The node name, e.g `green-guinea-pig-01`.
     * 
     */
    public Output<String> nodeName() {
        return this.nodeName;
    }
    /**
     * If the node is running.
     * 
     */
    @Export(name="running", refs={Boolean.class}, tree="[0]")
    private Output<Boolean> running;

    /**
     * @return If the node is running.
     * 
     */
    public Output<Boolean> running() {
        return this.running;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public NodeActions(String name) {
        this(name, NodeActionsArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public NodeActions(String name, NodeActionsArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public NodeActions(String name, NodeActionsArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/nodeActions:NodeActions", name, args == null ? NodeActionsArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private NodeActions(String name, Output<String> id, @Nullable NodeActionsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/nodeActions:NodeActions", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static NodeActions get(String name, Output<String> id, @Nullable NodeActionsState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new NodeActions(name, id, state, options);
    }
}
