// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.cloudamqp;

import com.pulumi.cloudamqp.NotificationArgs;
import com.pulumi.cloudamqp.Utilities;
import com.pulumi.cloudamqp.inputs.NotificationState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

/**
 * This resource allows you to create and manage recipients to receive alarm notifications. There will always be a default recipient created upon instance creation. This recipient will use team email and receive notifications from default alarms.
 * 
 * Available for all subscription plans.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.Notification;
 * import com.pulumi.cloudamqp.NotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var emailRecipient = new Notification(&#34;emailRecipient&#34;, NotificationArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .type(&#34;email&#34;)
 *             .value(&#34;alarm@example.com&#34;)
 *             .build());
 * 
 *         var victoropsRecipient = new Notification(&#34;victoropsRecipient&#34;, NotificationArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .type(&#34;victorops&#34;)
 *             .value(&#34;&lt;UUID&gt;&#34;)
 *             .options(Map.of(&#34;rk&#34;, &#34;ROUTINGKEY&#34;))
 *             .build());
 * 
 *         var pagerdutyRecipient = new Notification(&#34;pagerdutyRecipient&#34;, NotificationArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .type(&#34;pagerduty&#34;)
 *             .value(&#34;&lt;integration-key&gt;&#34;)
 *             .options(Map.of(&#34;dedupkey&#34;, &#34;DEDUPKEY&#34;))
 *             .build());
 * 
 *     }
 * }
 * ```
 * ## Notification Type reference
 * 
 * Valid options for notification type.
 * 
 * * email
 * * webhook
 * * pagerduty
 * * victorops
 * * opsgenie
 * * opsgenie-eu
 * * slack
 * * teams
 * 
 * ## Options parameter
 * 
 * | Type      | Options  | Description                                                                                                                                                                                                                                                                      | Note                                                                                                                                    |
 * |-----------|----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------|
 * | Victorops | rk       | Routing key to route alarm notification                                                                                                                                                                                                                                          | -                                                                                                                                        |
 * | PagerDuty | dedupkey | Default the dedup key for PagerDuty is generated depending on what alarm has triggered, but here you can set what `dedup` key to use so even if the same alarm is triggered for different resources you only get one notification. Leave blank to use the generated dedup key. | If multiple alarms are triggered using this recipient, since they all share `dedup` key only the first alarm will be shown in PagerDuty |
 * 
 * ## Dependency
 * 
 * This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.
 * 
 * ## Import
 * 
 * `cloudamqp_notification` can be imported using CloudAMQP internal identifier of a recipient together (CSV separated) with the instance identifier. To retrieve the identifier of a recipient, use [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html#list-notification-recipients)
 * 
 * ```sh
 *  $ pulumi import cloudamqp:index/notification:Notification recipient &lt;id&gt;,&lt;instance_id&gt;`
 * ```
 * 
 */
@ResourceType(type="cloudamqp:index/notification:Notification")
public class Notification extends com.pulumi.resources.CustomResource {
    /**
     * The CloudAMQP instance ID.
     * 
     */
    @Export(name="instanceId", refs={Integer.class}, tree="[0]")
    private Output<Integer> instanceId;

    /**
     * @return The CloudAMQP instance ID.
     * 
     */
    public Output<Integer> instanceId() {
        return this.instanceId;
    }
    /**
     * Display name of the recipient.
     * 
     */
    @Export(name="name", refs={String.class}, tree="[0]")
    private Output<String> name;

    /**
     * @return Display name of the recipient.
     * 
     */
    public Output<String> name() {
        return this.name;
    }
    /**
     * Options argument (e.g. `rk` used for VictorOps routing key).
     * 
     */
    @Export(name="options", refs={Map.class,String.class}, tree="[0,1,1]")
    private Output</* @Nullable */ Map<String,String>> options;

    /**
     * @return Options argument (e.g. `rk` used for VictorOps routing key).
     * 
     */
    public Output<Optional<Map<String,String>>> options() {
        return Codegen.optional(this.options);
    }
    /**
     * Type of the notification. See valid options below.
     * 
     */
    @Export(name="type", refs={String.class}, tree="[0]")
    private Output<String> type;

    /**
     * @return Type of the notification. See valid options below.
     * 
     */
    public Output<String> type() {
        return this.type;
    }
    /**
     * Integration/API key or endpoint to send the notification.
     * 
     */
    @Export(name="value", refs={String.class}, tree="[0]")
    private Output<String> value;

    /**
     * @return Integration/API key or endpoint to send the notification.
     * 
     */
    public Output<String> value() {
        return this.value;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Notification(String name) {
        this(name, NotificationArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Notification(String name, NotificationArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Notification(String name, NotificationArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/notification:Notification", name, args == null ? NotificationArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Notification(String name, Output<String> id, @Nullable NotificationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/notification:Notification", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Notification get(String name, Output<String> id, @Nullable NotificationState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Notification(name, id, state, options);
    }
}
