// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.cloudamqp;

import com.pulumi.cloudamqp.Utilities;
import com.pulumi.cloudamqp.WebhookArgs;
import com.pulumi.cloudamqp.inputs.WebhookState;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import java.lang.Integer;
import java.lang.String;
import javax.annotation.Nullable;

/**
 * This resource allows you to enable or disable webhooks for a specific vhost and queue.
 * 
 * Only available for dedicated subscription plans.
 * 
 * ## Example Usage
 * ```java
 * package generated_program;
 * 
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.cloudamqp.Webhook;
 * import com.pulumi.cloudamqp.WebhookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * 
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 * 
 *     public static void stack(Context ctx) {
 *         var webhookQueue = new Webhook(&#34;webhookQueue&#34;, WebhookArgs.builder()        
 *             .instanceId(cloudamqp_instance.instance().id())
 *             .vhost(&#34;myvhost&#34;)
 *             .queue(&#34;webhook-queue&#34;)
 *             .webhookUri(&#34;https://example.com/webhook?key=secret&#34;)
 *             .retryInterval(5)
 *             .concurrency(5)
 *             .build());
 * 
 *     }
 * }
 * ```
 * ## Dependency
 * 
 * This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.
 * 
 * ## Import
 * 
 * `cloudamqp_webhook` can be imported using the resource identifier together with CloudAMQP instance identifier. The identifiers are CSV separated, see example below.
 * 
 * ```sh
 *  $ pulumi import cloudamqp:index/webhook:Webhook webhook_queue &lt;id&gt;,&lt;instance_id&gt;`
 * ```
 * 
 */
@ResourceType(type="cloudamqp:index/webhook:Webhook")
public class Webhook extends com.pulumi.resources.CustomResource {
    /**
     * Max simultaneous requests to the endpoint.
     * 
     */
    @Export(name="concurrency", refs={Integer.class}, tree="[0]")
    private Output<Integer> concurrency;

    /**
     * @return Max simultaneous requests to the endpoint.
     * 
     */
    public Output<Integer> concurrency() {
        return this.concurrency;
    }
    /**
     * The CloudAMQP instance ID.
     * 
     */
    @Export(name="instanceId", refs={Integer.class}, tree="[0]")
    private Output<Integer> instanceId;

    /**
     * @return The CloudAMQP instance ID.
     * 
     */
    public Output<Integer> instanceId() {
        return this.instanceId;
    }
    /**
     * A (durable) queue on your RabbitMQ instance.
     * 
     */
    @Export(name="queue", refs={String.class}, tree="[0]")
    private Output<String> queue;

    /**
     * @return A (durable) queue on your RabbitMQ instance.
     * 
     */
    public Output<String> queue() {
        return this.queue;
    }
    /**
     * How often we retry if your endpoint fails (in seconds).
     * 
     */
    @Export(name="retryInterval", refs={Integer.class}, tree="[0]")
    private Output<Integer> retryInterval;

    /**
     * @return How often we retry if your endpoint fails (in seconds).
     * 
     */
    public Output<Integer> retryInterval() {
        return this.retryInterval;
    }
    /**
     * The vhost the queue resides in.
     * 
     */
    @Export(name="vhost", refs={String.class}, tree="[0]")
    private Output<String> vhost;

    /**
     * @return The vhost the queue resides in.
     * 
     */
    public Output<String> vhost() {
        return this.vhost;
    }
    /**
     * A POST request will be made for each message in the queue to this endpoint.
     * 
     */
    @Export(name="webhookUri", refs={String.class}, tree="[0]")
    private Output<String> webhookUri;

    /**
     * @return A POST request will be made for each message in the queue to this endpoint.
     * 
     */
    public Output<String> webhookUri() {
        return this.webhookUri;
    }

    /**
     *
     * @param name The _unique_ name of the resulting resource.
     */
    public Webhook(String name) {
        this(name, WebhookArgs.Empty);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     */
    public Webhook(String name, WebhookArgs args) {
        this(name, args, null);
    }
    /**
     *
     * @param name The _unique_ name of the resulting resource.
     * @param args The arguments to use to populate this resource's properties.
     * @param options A bag of options that control this resource's behavior.
     */
    public Webhook(String name, WebhookArgs args, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/webhook:Webhook", name, args == null ? WebhookArgs.Empty : args, makeResourceOptions(options, Codegen.empty()));
    }

    private Webhook(String name, Output<String> id, @Nullable WebhookState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        super("cloudamqp:index/webhook:Webhook", name, state, makeResourceOptions(options, id));
    }

    private static com.pulumi.resources.CustomResourceOptions makeResourceOptions(@Nullable com.pulumi.resources.CustomResourceOptions options, @Nullable Output<String> id) {
        var defaultOptions = com.pulumi.resources.CustomResourceOptions.builder()
            .version(Utilities.getVersion())
            .build();
        return com.pulumi.resources.CustomResourceOptions.merge(defaultOptions, options, id);
    }

    /**
     * Get an existing Host resource's state with the given name, ID, and optional extra
     * properties used to qualify the lookup.
     *
     * @param name The _unique_ name of the resulting resource.
     * @param id The _unique_ provider ID of the resource to lookup.
     * @param state
     * @param options Optional settings to control the behavior of the CustomResource.
     */
    public static Webhook get(String name, Output<String> id, @Nullable WebhookState state, @Nullable com.pulumi.resources.CustomResourceOptions options) {
        return new Webhook(name, id, state, options);
    }
}
