// *** WARNING: this file was generated by pulumi-java-gen. ***
// *** Do not edit by hand unless you're certain you know what you are doing! ***

package com.pulumi.cloudamqp.inputs;

import com.pulumi.cloudamqp.inputs.InstanceCopySettingArgs;
import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.String;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;


public final class InstanceState extends com.pulumi.resources.ResourceArgs {

    public static final InstanceState Empty = new InstanceState();

    /**
     * API key needed to communicate to CloudAMQP&#39;s second API. The second API is used to manage alarms, integration and more, full description [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html).
     * 
     */
    @Import(name="apikey")
    private @Nullable Output<String> apikey;

    /**
     * @return API key needed to communicate to CloudAMQP&#39;s second API. The second API is used to manage alarms, integration and more, full description [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html).
     * 
     */
    public Optional<Output<String>> apikey() {
        return Optional.ofNullable(this.apikey);
    }

    /**
     * Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
     * 
     */
    @Import(name="backend")
    private @Nullable Output<String> backend;

    /**
     * @return Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
     * 
     */
    public Optional<Output<String>> backend() {
        return Optional.ofNullable(this.backend);
    }

    /**
     * Copy settings from one CloudAMQP instance to a new. Consists of the block documented below.
     * 
     * ***
     * 
     * The `copy_settings` block consists of:
     * 
     */
    @Import(name="copySettings")
    private @Nullable Output<List<InstanceCopySettingArgs>> copySettings;

    /**
     * @return Copy settings from one CloudAMQP instance to a new. Consists of the block documented below.
     * 
     * ***
     * 
     * The `copy_settings` block consists of:
     * 
     */
    public Optional<Output<List<InstanceCopySettingArgs>>> copySettings() {
        return Optional.ofNullable(this.copySettings);
    }

    /**
     * Information if the CloudAMQP instance is shared or dedicated.
     * 
     */
    @Import(name="dedicated")
    private @Nullable Output<Boolean> dedicated;

    /**
     * @return Information if the CloudAMQP instance is shared or dedicated.
     * 
     */
    public Optional<Output<Boolean>> dedicated() {
        return Optional.ofNullable(this.dedicated);
    }

    /**
     * The external hostname for the CloudAMQP instance.
     * 
     */
    @Import(name="host")
    private @Nullable Output<String> host;

    /**
     * @return The external hostname for the CloudAMQP instance.
     * 
     */
    public Optional<Output<String>> host() {
        return Optional.ofNullable(this.host);
    }

    /**
     * The internal hostname for the CloudAMQP instance.
     * 
     */
    @Import(name="hostInternal")
    private @Nullable Output<String> hostInternal;

    /**
     * @return The internal hostname for the CloudAMQP instance.
     * 
     */
    public Optional<Output<String>> hostInternal() {
        return Optional.ofNullable(this.hostInternal);
    }

    /**
     * Keep associated VPC when deleting instance, default set to false.
     * 
     */
    @Import(name="keepAssociatedVpc")
    private @Nullable Output<Boolean> keepAssociatedVpc;

    /**
     * @return Keep associated VPC when deleting instance, default set to false.
     * 
     */
    public Optional<Output<Boolean>> keepAssociatedVpc() {
        return Optional.ofNullable(this.keepAssociatedVpc);
    }

    /**
     * Name of the CloudAMQP instance.
     * 
     */
    @Import(name="name")
    private @Nullable Output<String> name;

    /**
     * @return Name of the CloudAMQP instance.
     * 
     */
    public Optional<Output<String>> name() {
        return Optional.ofNullable(this.name);
    }

    /**
     * Set to true to discard creating default alarms when the instance is created. Can be left out, will then use default value = false.
     * 
     */
    @Import(name="noDefaultAlarms")
    private @Nullable Output<Boolean> noDefaultAlarms;

    /**
     * @return Set to true to discard creating default alarms when the instance is created. Can be left out, will then use default value = false.
     * 
     */
    public Optional<Output<Boolean>> noDefaultAlarms() {
        return Optional.ofNullable(this.noDefaultAlarms);
    }

    /**
     * Number of nodes, 1, 3 or 5 depending on plan used. Only needed for legacy plans, will otherwise be computed.
     * 
     * ***Deprecated: Legacy subscriptions plan can still change this to scale up or down the instance. New subscriptions plans use the plan to determine number of nodes. In order to change number of nodes the `plan` needs to be updated.***
     * 
     */
    @Import(name="nodes")
    private @Nullable Output<Integer> nodes;

    /**
     * @return Number of nodes, 1, 3 or 5 depending on plan used. Only needed for legacy plans, will otherwise be computed.
     * 
     * ***Deprecated: Legacy subscriptions plan can still change this to scale up or down the instance. New subscriptions plans use the plan to determine number of nodes. In order to change number of nodes the `plan` needs to be updated.***
     * 
     */
    public Optional<Output<Integer>> nodes() {
        return Optional.ofNullable(this.nodes);
    }

    /**
     * The subscription plan. See available plans
     * 
     */
    @Import(name="plan")
    private @Nullable Output<String> plan;

    /**
     * @return The subscription plan. See available plans
     * 
     */
    public Optional<Output<String>> plan() {
        return Optional.ofNullable(this.plan);
    }

    /**
     * Flag describing if the resource is ready
     * 
     */
    @Import(name="ready")
    private @Nullable Output<Boolean> ready;

    /**
     * @return Flag describing if the resource is ready
     * 
     */
    public Optional<Output<Boolean>> ready() {
        return Optional.ofNullable(this.ready);
    }

    /**
     * The region to host the instance in. See instance regions
     * 
     * ***Note: Changing region will force the instance to be destroyed and a new created in the new region. All data will be lost and a new name assigned.***
     * 
     */
    @Import(name="region")
    private @Nullable Output<String> region;

    /**
     * @return The region to host the instance in. See instance regions
     * 
     * ***Note: Changing region will force the instance to be destroyed and a new created in the new region. All data will be lost and a new name assigned.***
     * 
     */
    public Optional<Output<String>> region() {
        return Optional.ofNullable(this.region);
    }

    /**
     * The Rabbit MQ version. Can be left out, will then be set to default value used by CloudAMQP API.
     * 
     * ***Note: There is not yet any support in the provider to change the RMQ version. Once it&#39;s set in the initial creation, it will remain.***
     * 
     */
    @Import(name="rmqVersion")
    private @Nullable Output<String> rmqVersion;

    /**
     * @return The Rabbit MQ version. Can be left out, will then be set to default value used by CloudAMQP API.
     * 
     * ***Note: There is not yet any support in the provider to change the RMQ version. Once it&#39;s set in the initial creation, it will remain.***
     * 
     */
    public Optional<Output<String>> rmqVersion() {
        return Optional.ofNullable(this.rmqVersion);
    }

    /**
     * One or more tags for the CloudAMQP instance, makes it possible to categories multiple instances in console view. Default there is no tags assigned.
     * 
     */
    @Import(name="tags")
    private @Nullable Output<List<String>> tags;

    /**
     * @return One or more tags for the CloudAMQP instance, makes it possible to categories multiple instances in console view. Default there is no tags assigned.
     * 
     */
    public Optional<Output<List<String>>> tags() {
        return Optional.ofNullable(this.tags);
    }

    /**
     * The AMQP URL (uses the internal hostname if the instance was created with VPC). Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
     * 
     */
    @Import(name="url")
    private @Nullable Output<String> url;

    /**
     * @return The AMQP URL (uses the internal hostname if the instance was created with VPC). Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
     * 
     */
    public Optional<Output<String>> url() {
        return Optional.ofNullable(this.url);
    }

    /**
     * The virtual host used by Rabbit MQ.
     * 
     */
    @Import(name="vhost")
    private @Nullable Output<String> vhost;

    /**
     * @return The virtual host used by Rabbit MQ.
     * 
     */
    public Optional<Output<String>> vhost() {
        return Optional.ofNullable(this.vhost);
    }

    /**
     * The VPC ID. Use this to create your instance in an existing VPC. See available example.
     * 
     */
    @Import(name="vpcId")
    private @Nullable Output<Integer> vpcId;

    /**
     * @return The VPC ID. Use this to create your instance in an existing VPC. See available example.
     * 
     */
    public Optional<Output<Integer>> vpcId() {
        return Optional.ofNullable(this.vpcId);
    }

    /**
     * Creates a dedicated VPC subnet, shouldn&#39;t overlap with other VPC subnet, default subnet used 10.56.72.0/24.
     * 
     * ***Deprecated: Will be removed in next major version (v2.0)***
     * 
     * ***Note: extra fee will be charged when using VPC, see [CloudAMQP](https://cloudamqp.com) for more information.***
     * 
     */
    @Import(name="vpcSubnet")
    private @Nullable Output<String> vpcSubnet;

    /**
     * @return Creates a dedicated VPC subnet, shouldn&#39;t overlap with other VPC subnet, default subnet used 10.56.72.0/24.
     * 
     * ***Deprecated: Will be removed in next major version (v2.0)***
     * 
     * ***Note: extra fee will be charged when using VPC, see [CloudAMQP](https://cloudamqp.com) for more information.***
     * 
     */
    public Optional<Output<String>> vpcSubnet() {
        return Optional.ofNullable(this.vpcSubnet);
    }

    private InstanceState() {}

    private InstanceState(InstanceState $) {
        this.apikey = $.apikey;
        this.backend = $.backend;
        this.copySettings = $.copySettings;
        this.dedicated = $.dedicated;
        this.host = $.host;
        this.hostInternal = $.hostInternal;
        this.keepAssociatedVpc = $.keepAssociatedVpc;
        this.name = $.name;
        this.noDefaultAlarms = $.noDefaultAlarms;
        this.nodes = $.nodes;
        this.plan = $.plan;
        this.ready = $.ready;
        this.region = $.region;
        this.rmqVersion = $.rmqVersion;
        this.tags = $.tags;
        this.url = $.url;
        this.vhost = $.vhost;
        this.vpcId = $.vpcId;
        this.vpcSubnet = $.vpcSubnet;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(InstanceState defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private InstanceState $;

        public Builder() {
            $ = new InstanceState();
        }

        public Builder(InstanceState defaults) {
            $ = new InstanceState(Objects.requireNonNull(defaults));
        }

        /**
         * @param apikey API key needed to communicate to CloudAMQP&#39;s second API. The second API is used to manage alarms, integration and more, full description [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html).
         * 
         * @return builder
         * 
         */
        public Builder apikey(@Nullable Output<String> apikey) {
            $.apikey = apikey;
            return this;
        }

        /**
         * @param apikey API key needed to communicate to CloudAMQP&#39;s second API. The second API is used to manage alarms, integration and more, full description [CloudAMQP API](https://docs.cloudamqp.com/cloudamqp_api.html).
         * 
         * @return builder
         * 
         */
        public Builder apikey(String apikey) {
            return apikey(Output.of(apikey));
        }

        /**
         * @param backend Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
         * 
         * @return builder
         * 
         */
        public Builder backend(@Nullable Output<String> backend) {
            $.backend = backend;
            return this;
        }

        /**
         * @param backend Information if the CloudAMQP instance runs either RabbitMQ or LavinMQ.
         * 
         * @return builder
         * 
         */
        public Builder backend(String backend) {
            return backend(Output.of(backend));
        }

        /**
         * @param copySettings Copy settings from one CloudAMQP instance to a new. Consists of the block documented below.
         * 
         * ***
         * 
         * The `copy_settings` block consists of:
         * 
         * @return builder
         * 
         */
        public Builder copySettings(@Nullable Output<List<InstanceCopySettingArgs>> copySettings) {
            $.copySettings = copySettings;
            return this;
        }

        /**
         * @param copySettings Copy settings from one CloudAMQP instance to a new. Consists of the block documented below.
         * 
         * ***
         * 
         * The `copy_settings` block consists of:
         * 
         * @return builder
         * 
         */
        public Builder copySettings(List<InstanceCopySettingArgs> copySettings) {
            return copySettings(Output.of(copySettings));
        }

        /**
         * @param copySettings Copy settings from one CloudAMQP instance to a new. Consists of the block documented below.
         * 
         * ***
         * 
         * The `copy_settings` block consists of:
         * 
         * @return builder
         * 
         */
        public Builder copySettings(InstanceCopySettingArgs... copySettings) {
            return copySettings(List.of(copySettings));
        }

        /**
         * @param dedicated Information if the CloudAMQP instance is shared or dedicated.
         * 
         * @return builder
         * 
         */
        public Builder dedicated(@Nullable Output<Boolean> dedicated) {
            $.dedicated = dedicated;
            return this;
        }

        /**
         * @param dedicated Information if the CloudAMQP instance is shared or dedicated.
         * 
         * @return builder
         * 
         */
        public Builder dedicated(Boolean dedicated) {
            return dedicated(Output.of(dedicated));
        }

        /**
         * @param host The external hostname for the CloudAMQP instance.
         * 
         * @return builder
         * 
         */
        public Builder host(@Nullable Output<String> host) {
            $.host = host;
            return this;
        }

        /**
         * @param host The external hostname for the CloudAMQP instance.
         * 
         * @return builder
         * 
         */
        public Builder host(String host) {
            return host(Output.of(host));
        }

        /**
         * @param hostInternal The internal hostname for the CloudAMQP instance.
         * 
         * @return builder
         * 
         */
        public Builder hostInternal(@Nullable Output<String> hostInternal) {
            $.hostInternal = hostInternal;
            return this;
        }

        /**
         * @param hostInternal The internal hostname for the CloudAMQP instance.
         * 
         * @return builder
         * 
         */
        public Builder hostInternal(String hostInternal) {
            return hostInternal(Output.of(hostInternal));
        }

        /**
         * @param keepAssociatedVpc Keep associated VPC when deleting instance, default set to false.
         * 
         * @return builder
         * 
         */
        public Builder keepAssociatedVpc(@Nullable Output<Boolean> keepAssociatedVpc) {
            $.keepAssociatedVpc = keepAssociatedVpc;
            return this;
        }

        /**
         * @param keepAssociatedVpc Keep associated VPC when deleting instance, default set to false.
         * 
         * @return builder
         * 
         */
        public Builder keepAssociatedVpc(Boolean keepAssociatedVpc) {
            return keepAssociatedVpc(Output.of(keepAssociatedVpc));
        }

        /**
         * @param name Name of the CloudAMQP instance.
         * 
         * @return builder
         * 
         */
        public Builder name(@Nullable Output<String> name) {
            $.name = name;
            return this;
        }

        /**
         * @param name Name of the CloudAMQP instance.
         * 
         * @return builder
         * 
         */
        public Builder name(String name) {
            return name(Output.of(name));
        }

        /**
         * @param noDefaultAlarms Set to true to discard creating default alarms when the instance is created. Can be left out, will then use default value = false.
         * 
         * @return builder
         * 
         */
        public Builder noDefaultAlarms(@Nullable Output<Boolean> noDefaultAlarms) {
            $.noDefaultAlarms = noDefaultAlarms;
            return this;
        }

        /**
         * @param noDefaultAlarms Set to true to discard creating default alarms when the instance is created. Can be left out, will then use default value = false.
         * 
         * @return builder
         * 
         */
        public Builder noDefaultAlarms(Boolean noDefaultAlarms) {
            return noDefaultAlarms(Output.of(noDefaultAlarms));
        }

        /**
         * @param nodes Number of nodes, 1, 3 or 5 depending on plan used. Only needed for legacy plans, will otherwise be computed.
         * 
         * ***Deprecated: Legacy subscriptions plan can still change this to scale up or down the instance. New subscriptions plans use the plan to determine number of nodes. In order to change number of nodes the `plan` needs to be updated.***
         * 
         * @return builder
         * 
         */
        public Builder nodes(@Nullable Output<Integer> nodes) {
            $.nodes = nodes;
            return this;
        }

        /**
         * @param nodes Number of nodes, 1, 3 or 5 depending on plan used. Only needed for legacy plans, will otherwise be computed.
         * 
         * ***Deprecated: Legacy subscriptions plan can still change this to scale up or down the instance. New subscriptions plans use the plan to determine number of nodes. In order to change number of nodes the `plan` needs to be updated.***
         * 
         * @return builder
         * 
         */
        public Builder nodes(Integer nodes) {
            return nodes(Output.of(nodes));
        }

        /**
         * @param plan The subscription plan. See available plans
         * 
         * @return builder
         * 
         */
        public Builder plan(@Nullable Output<String> plan) {
            $.plan = plan;
            return this;
        }

        /**
         * @param plan The subscription plan. See available plans
         * 
         * @return builder
         * 
         */
        public Builder plan(String plan) {
            return plan(Output.of(plan));
        }

        /**
         * @param ready Flag describing if the resource is ready
         * 
         * @return builder
         * 
         */
        public Builder ready(@Nullable Output<Boolean> ready) {
            $.ready = ready;
            return this;
        }

        /**
         * @param ready Flag describing if the resource is ready
         * 
         * @return builder
         * 
         */
        public Builder ready(Boolean ready) {
            return ready(Output.of(ready));
        }

        /**
         * @param region The region to host the instance in. See instance regions
         * 
         * ***Note: Changing region will force the instance to be destroyed and a new created in the new region. All data will be lost and a new name assigned.***
         * 
         * @return builder
         * 
         */
        public Builder region(@Nullable Output<String> region) {
            $.region = region;
            return this;
        }

        /**
         * @param region The region to host the instance in. See instance regions
         * 
         * ***Note: Changing region will force the instance to be destroyed and a new created in the new region. All data will be lost and a new name assigned.***
         * 
         * @return builder
         * 
         */
        public Builder region(String region) {
            return region(Output.of(region));
        }

        /**
         * @param rmqVersion The Rabbit MQ version. Can be left out, will then be set to default value used by CloudAMQP API.
         * 
         * ***Note: There is not yet any support in the provider to change the RMQ version. Once it&#39;s set in the initial creation, it will remain.***
         * 
         * @return builder
         * 
         */
        public Builder rmqVersion(@Nullable Output<String> rmqVersion) {
            $.rmqVersion = rmqVersion;
            return this;
        }

        /**
         * @param rmqVersion The Rabbit MQ version. Can be left out, will then be set to default value used by CloudAMQP API.
         * 
         * ***Note: There is not yet any support in the provider to change the RMQ version. Once it&#39;s set in the initial creation, it will remain.***
         * 
         * @return builder
         * 
         */
        public Builder rmqVersion(String rmqVersion) {
            return rmqVersion(Output.of(rmqVersion));
        }

        /**
         * @param tags One or more tags for the CloudAMQP instance, makes it possible to categories multiple instances in console view. Default there is no tags assigned.
         * 
         * @return builder
         * 
         */
        public Builder tags(@Nullable Output<List<String>> tags) {
            $.tags = tags;
            return this;
        }

        /**
         * @param tags One or more tags for the CloudAMQP instance, makes it possible to categories multiple instances in console view. Default there is no tags assigned.
         * 
         * @return builder
         * 
         */
        public Builder tags(List<String> tags) {
            return tags(Output.of(tags));
        }

        /**
         * @param tags One or more tags for the CloudAMQP instance, makes it possible to categories multiple instances in console view. Default there is no tags assigned.
         * 
         * @return builder
         * 
         */
        public Builder tags(String... tags) {
            return tags(List.of(tags));
        }

        /**
         * @param url The AMQP URL (uses the internal hostname if the instance was created with VPC). Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
         * 
         * @return builder
         * 
         */
        public Builder url(@Nullable Output<String> url) {
            $.url = url;
            return this;
        }

        /**
         * @param url The AMQP URL (uses the internal hostname if the instance was created with VPC). Has the format: `amqps://{username}:{password}@{hostname}/{vhost}`
         * 
         * @return builder
         * 
         */
        public Builder url(String url) {
            return url(Output.of(url));
        }

        /**
         * @param vhost The virtual host used by Rabbit MQ.
         * 
         * @return builder
         * 
         */
        public Builder vhost(@Nullable Output<String> vhost) {
            $.vhost = vhost;
            return this;
        }

        /**
         * @param vhost The virtual host used by Rabbit MQ.
         * 
         * @return builder
         * 
         */
        public Builder vhost(String vhost) {
            return vhost(Output.of(vhost));
        }

        /**
         * @param vpcId The VPC ID. Use this to create your instance in an existing VPC. See available example.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(@Nullable Output<Integer> vpcId) {
            $.vpcId = vpcId;
            return this;
        }

        /**
         * @param vpcId The VPC ID. Use this to create your instance in an existing VPC. See available example.
         * 
         * @return builder
         * 
         */
        public Builder vpcId(Integer vpcId) {
            return vpcId(Output.of(vpcId));
        }

        /**
         * @param vpcSubnet Creates a dedicated VPC subnet, shouldn&#39;t overlap with other VPC subnet, default subnet used 10.56.72.0/24.
         * 
         * ***Deprecated: Will be removed in next major version (v2.0)***
         * 
         * ***Note: extra fee will be charged when using VPC, see [CloudAMQP](https://cloudamqp.com) for more information.***
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnet(@Nullable Output<String> vpcSubnet) {
            $.vpcSubnet = vpcSubnet;
            return this;
        }

        /**
         * @param vpcSubnet Creates a dedicated VPC subnet, shouldn&#39;t overlap with other VPC subnet, default subnet used 10.56.72.0/24.
         * 
         * ***Deprecated: Will be removed in next major version (v2.0)***
         * 
         * ***Note: extra fee will be charged when using VPC, see [CloudAMQP](https://cloudamqp.com) for more information.***
         * 
         * @return builder
         * 
         */
        public Builder vpcSubnet(String vpcSubnet) {
            return vpcSubnet(Output.of(vpcSubnet));
        }

        public InstanceState build() {
            return $;
        }
    }

}
