/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.cloudamqp.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class SecurityFirewallRule {
    @Nullable
    private String description;
    private String ip;
    @Nullable
    private List<Integer> ports;
    @Nullable
    private List<String> services;

    private SecurityFirewallRule() {
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public String ip() {
        return this.ip;
    }

    public List<Integer> ports() {
        return this.ports == null ? List.of() : this.ports;
    }

    public List<String> services() {
        return this.services == null ? List.of() : this.services;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(SecurityFirewallRule defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String description;
        private String ip;
        @Nullable
        private List<Integer> ports;
        @Nullable
        private List<String> services;

        public Builder() {
        }

        public Builder(SecurityFirewallRule defaults) {
            Objects.requireNonNull(defaults);
            this.description = defaults.description;
            this.ip = defaults.ip;
            this.ports = defaults.ports;
            this.services = defaults.services;
        }

        @CustomType.Setter
        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @CustomType.Setter
        public Builder ip(String ip) {
            if (ip == null) {
                throw new MissingRequiredPropertyException("SecurityFirewallRule", "ip");
            }
            this.ip = ip;
            return this;
        }

        @CustomType.Setter
        public Builder ports(@Nullable List<Integer> ports) {
            this.ports = ports;
            return this;
        }

        public Builder ports(Integer ... ports) {
            return this.ports(List.of(ports));
        }

        @CustomType.Setter
        public Builder services(@Nullable List<String> services) {
            this.services = services;
            return this;
        }

        public Builder services(String ... services) {
            return this.services(List.of(services));
        }

        public SecurityFirewallRule build() {
            SecurityFirewallRule _resultValue = new SecurityFirewallRule();
            _resultValue.description = this.description;
            _resultValue.ip = this.ip;
            _resultValue.ports = this.ports;
            _resultValue.services = this.services;
            return _resultValue;
        }
    }
}

