/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.admissionregistration.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.admissionregistration.v1.outputs.MatchCondition;
import com.pulumi.kubernetes.admissionregistration.v1.outputs.RuleWithOperations;
import com.pulumi.kubernetes.admissionregistration.v1.outputs.WebhookClientConfig;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class MutatingWebhook {
    private List<String> admissionReviewVersions;
    private WebhookClientConfig clientConfig;
    @Nullable
    private String failurePolicy;
    @Nullable
    private List<MatchCondition> matchConditions;
    @Nullable
    private String matchPolicy;
    private String name;
    @Nullable
    private LabelSelector namespaceSelector;
    @Nullable
    private LabelSelector objectSelector;
    @Nullable
    private String reinvocationPolicy;
    @Nullable
    private List<RuleWithOperations> rules;
    private String sideEffects;
    @Nullable
    private Integer timeoutSeconds;

    private MutatingWebhook() {
    }

    public List<String> admissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public WebhookClientConfig clientConfig() {
        return this.clientConfig;
    }

    public Optional<String> failurePolicy() {
        return Optional.ofNullable(this.failurePolicy);
    }

    public List<MatchCondition> matchConditions() {
        return this.matchConditions == null ? List.of() : this.matchConditions;
    }

    public Optional<String> matchPolicy() {
        return Optional.ofNullable(this.matchPolicy);
    }

    public String name() {
        return this.name;
    }

    public Optional<LabelSelector> namespaceSelector() {
        return Optional.ofNullable(this.namespaceSelector);
    }

    public Optional<LabelSelector> objectSelector() {
        return Optional.ofNullable(this.objectSelector);
    }

    public Optional<String> reinvocationPolicy() {
        return Optional.ofNullable(this.reinvocationPolicy);
    }

    public List<RuleWithOperations> rules() {
        return this.rules == null ? List.of() : this.rules;
    }

    public String sideEffects() {
        return this.sideEffects;
    }

    public Optional<Integer> timeoutSeconds() {
        return Optional.ofNullable(this.timeoutSeconds);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MutatingWebhook defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> admissionReviewVersions;
        private WebhookClientConfig clientConfig;
        @Nullable
        private String failurePolicy;
        @Nullable
        private List<MatchCondition> matchConditions;
        @Nullable
        private String matchPolicy;
        private String name;
        @Nullable
        private LabelSelector namespaceSelector;
        @Nullable
        private LabelSelector objectSelector;
        @Nullable
        private String reinvocationPolicy;
        @Nullable
        private List<RuleWithOperations> rules;
        private String sideEffects;
        @Nullable
        private Integer timeoutSeconds;

        public Builder() {
        }

        public Builder(MutatingWebhook defaults) {
            Objects.requireNonNull(defaults);
            this.admissionReviewVersions = defaults.admissionReviewVersions;
            this.clientConfig = defaults.clientConfig;
            this.failurePolicy = defaults.failurePolicy;
            this.matchConditions = defaults.matchConditions;
            this.matchPolicy = defaults.matchPolicy;
            this.name = defaults.name;
            this.namespaceSelector = defaults.namespaceSelector;
            this.objectSelector = defaults.objectSelector;
            this.reinvocationPolicy = defaults.reinvocationPolicy;
            this.rules = defaults.rules;
            this.sideEffects = defaults.sideEffects;
            this.timeoutSeconds = defaults.timeoutSeconds;
        }

        @CustomType.Setter
        public Builder admissionReviewVersions(List<String> admissionReviewVersions) {
            if (admissionReviewVersions == null) {
                throw new MissingRequiredPropertyException("MutatingWebhook", "admissionReviewVersions");
            }
            this.admissionReviewVersions = admissionReviewVersions;
            return this;
        }

        public Builder admissionReviewVersions(String ... admissionReviewVersions) {
            return this.admissionReviewVersions(List.of(admissionReviewVersions));
        }

        @CustomType.Setter
        public Builder clientConfig(WebhookClientConfig clientConfig) {
            if (clientConfig == null) {
                throw new MissingRequiredPropertyException("MutatingWebhook", "clientConfig");
            }
            this.clientConfig = clientConfig;
            return this;
        }

        @CustomType.Setter
        public Builder failurePolicy(@Nullable String failurePolicy) {
            this.failurePolicy = failurePolicy;
            return this;
        }

        @CustomType.Setter
        public Builder matchConditions(@Nullable List<MatchCondition> matchConditions) {
            this.matchConditions = matchConditions;
            return this;
        }

        public Builder matchConditions(MatchCondition ... matchConditions) {
            return this.matchConditions(List.of(matchConditions));
        }

        @CustomType.Setter
        public Builder matchPolicy(@Nullable String matchPolicy) {
            this.matchPolicy = matchPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("MutatingWebhook", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder namespaceSelector(@Nullable LabelSelector namespaceSelector) {
            this.namespaceSelector = namespaceSelector;
            return this;
        }

        @CustomType.Setter
        public Builder objectSelector(@Nullable LabelSelector objectSelector) {
            this.objectSelector = objectSelector;
            return this;
        }

        @CustomType.Setter
        public Builder reinvocationPolicy(@Nullable String reinvocationPolicy) {
            this.reinvocationPolicy = reinvocationPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder rules(@Nullable List<RuleWithOperations> rules) {
            this.rules = rules;
            return this;
        }

        public Builder rules(RuleWithOperations ... rules) {
            return this.rules(List.of(rules));
        }

        @CustomType.Setter
        public Builder sideEffects(String sideEffects) {
            if (sideEffects == null) {
                throw new MissingRequiredPropertyException("MutatingWebhook", "sideEffects");
            }
            this.sideEffects = sideEffects;
            return this;
        }

        @CustomType.Setter
        public Builder timeoutSeconds(@Nullable Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public MutatingWebhook build() {
            MutatingWebhook _resultValue = new MutatingWebhook();
            _resultValue.admissionReviewVersions = this.admissionReviewVersions;
            _resultValue.clientConfig = this.clientConfig;
            _resultValue.failurePolicy = this.failurePolicy;
            _resultValue.matchConditions = this.matchConditions;
            _resultValue.matchPolicy = this.matchPolicy;
            _resultValue.name = this.name;
            _resultValue.namespaceSelector = this.namespaceSelector;
            _resultValue.objectSelector = this.objectSelector;
            _resultValue.reinvocationPolicy = this.reinvocationPolicy;
            _resultValue.rules = this.rules;
            _resultValue.sideEffects = this.sideEffects;
            _resultValue.timeoutSeconds = this.timeoutSeconds;
            return _resultValue;
        }
    }
}

