/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.admissionregistration.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ServiceReference {
    private String name;
    private String namespace;
    @Nullable
    private String path;
    @Nullable
    private Integer port;

    private ServiceReference() {
    }

    public String name() {
        return this.name;
    }

    public String namespace() {
        return this.namespace;
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public Optional<Integer> port() {
        return Optional.ofNullable(this.port);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ServiceReference defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private String name;
        private String namespace;
        @Nullable
        private String path;
        @Nullable
        private Integer port;

        public Builder() {
        }

        public Builder(ServiceReference defaults) {
            Objects.requireNonNull(defaults);
            this.name = defaults.name;
            this.namespace = defaults.namespace;
            this.path = defaults.path;
            this.port = defaults.port;
        }

        @CustomType.Setter
        public Builder name(String name) {
            if (name == null) {
                throw new MissingRequiredPropertyException("ServiceReference", "name");
            }
            this.name = name;
            return this;
        }

        @CustomType.Setter
        public Builder namespace(String namespace) {
            if (namespace == null) {
                throw new MissingRequiredPropertyException("ServiceReference", "namespace");
            }
            this.namespace = namespace;
            return this;
        }

        @CustomType.Setter
        public Builder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @CustomType.Setter
        public Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public ServiceReference build() {
            ServiceReference _resultValue = new ServiceReference();
            _resultValue.name = this.name;
            _resultValue.namespace = this.namespace;
            _resultValue.path = this.path;
            _resultValue.port = this.port;
            return _resultValue;
        }
    }
}

