/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apiextensions;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.core.internal.Internal;
import com.pulumi.core.internal.OutputInternal;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.apiextensions.CustomResourceArgs;
import com.pulumi.kubernetes.apiextensions.CustomResourceArgsBase;
import com.pulumi.kubernetes.apiextensions.Util;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import com.pulumi.resources.CustomResourceOptions;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

@ResourceType(type="kubernetes:apiextensions:CustomResource")
public class CustomResource
extends com.pulumi.resources.CustomResource {
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output<String> apiVersion;
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output<String> kind;
    @Export(name="metadata", refs={ObjectMeta.class}, tree="[0]")
    private Output<ObjectMeta> metadata;

    public Output<String> apiVersion() {
        return this.apiVersion;
    }

    public Output<String> kind() {
        return this.kind;
    }

    public Output<ObjectMeta> metadata() {
        return this.metadata;
    }

    public CustomResource(String name) {
        this(name, CustomResourceArgs.Empty);
    }

    public CustomResource(String name, CustomResourceArgsBase args) {
        this(name, args, null);
    }

    public CustomResource(String name, CustomResourceArgsBase args, @Nullable CustomResourceOptions options) {
        super(CustomResource.makeType(args), name, CustomResource.makeArgs(args), CustomResource.makeResourceOptions(options, (Output<String>)Codegen.empty()));
    }

    protected CustomResource(String name, String apiVersion, String kind, Output<String> id, @Nullable CustomResourceOptions options) {
        super(String.format("kubernetes:%s:%s", apiVersion, kind), name, null, CustomResource.makeResourceOptions(options, id));
    }

    private static String makeType(CustomResourceArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        String apiVersion = args.apiVersion().map(Internal::of).map(CustomResource::getOutputValue).orElse("");
        String kind = args.kind().map(Internal::of).map(CustomResource::getOutputValue).orElse("");
        return String.format("kubernetes:%s:%s", apiVersion, kind);
    }

    private static String getOutputValue(OutputInternal<String> o) {
        try {
            return (String)o.getValueOrDefault((Object)"").get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResourceArgs makeArgs(CustomResourceArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        if (args.otherFields().isEmpty() || args.otherFields().get().isEmpty()) {
            return args;
        }
        return Util.generateResourceArgs(args, args.otherFields().get());
    }

    private static CustomResourceOptions makeResourceOptions(@Nullable CustomResourceOptions options, @Nullable Output<String> id) {
        CustomResourceOptions defaultOptions = ((CustomResourceOptions.Builder)CustomResourceOptions.builder().version(Utilities.getVersion())).build();
        return CustomResourceOptions.merge((CustomResourceOptions)defaultOptions, (CustomResourceOptions)options, id);
    }

    public static CustomResource get(String name, String apiVersion, String kind, Output<String> id, @Nullable CustomResourceOptions options) {
        return new CustomResource(name, apiVersion, kind, id, options);
    }
}

