/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apiextensions;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Export;
import com.pulumi.core.annotations.ResourceType;
import com.pulumi.core.internal.Codegen;
import com.pulumi.core.internal.Internal;
import com.pulumi.core.internal.OutputInternal;
import com.pulumi.kubernetes.Utilities;
import com.pulumi.kubernetes.apiextensions.CustomResourcePatchArgs;
import com.pulumi.kubernetes.apiextensions.CustomResourcePatchArgsBase;
import com.pulumi.kubernetes.apiextensions.Util;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMetaPatch;
import com.pulumi.resources.CustomResource;
import com.pulumi.resources.CustomResourceOptions;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

@ResourceType(type="kubernetes:apiextensions:CustomResourcePatch")
public class CustomResourcePatch
extends CustomResource {
    @Export(name="apiVersion", refs={String.class}, tree="[0]")
    private Output<String> apiVersion;
    @Export(name="kind", refs={String.class}, tree="[0]")
    private Output<String> kind;
    @Export(name="metadata", refs={ObjectMetaPatch.class}, tree="[0]")
    private Output<ObjectMetaPatch> metadata;

    public Output<Optional<String>> apiVersion() {
        return Codegen.optional(this.apiVersion);
    }

    public Output<Optional<String>> kind() {
        return Codegen.optional(this.kind);
    }

    public Output<Optional<ObjectMetaPatch>> metadata() {
        return Codegen.optional(this.metadata);
    }

    public CustomResourcePatch(String name) {
        this(name, CustomResourcePatchArgs.Empty);
    }

    public CustomResourcePatch(String name, CustomResourcePatchArgsBase args) {
        this(name, args, null);
    }

    public CustomResourcePatch(String name, CustomResourcePatchArgsBase args, @Nullable CustomResourceOptions options) {
        super(CustomResourcePatch.makeType(args), name, CustomResourcePatch.makeArgs(args), CustomResourcePatch.makeResourceOptions(options, (Output<String>)Codegen.empty()));
    }

    private static String makeType(CustomResourcePatchArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        String apiVersion = args.apiVersion().map(Internal::of).map(CustomResourcePatch::getOutputValue).orElse("");
        String kind = args.kind().map(Internal::of).map(CustomResourcePatch::getOutputValue).orElse("");
        return String.format("kubernetes:%s:%sPatch", apiVersion, kind);
    }

    private static String getOutputValue(OutputInternal<String> o) {
        try {
            return (String)o.getValueOrDefault((Object)"").get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResourceArgs makeArgs(@Nullable CustomResourcePatchArgsBase args) {
        Objects.requireNonNull(args, "args must not be null");
        if (args.otherFields().isEmpty() || args.otherFields().get().isEmpty()) {
            return args;
        }
        return Util.generateResourceArgs(args, args.otherFields().get());
    }

    private static CustomResourceOptions makeResourceOptions(@Nullable CustomResourceOptions options, @Nullable Output<String> id) {
        CustomResourceOptions defaultOptions = ((CustomResourceOptions.Builder)CustomResourceOptions.builder().version(Utilities.getVersion())).build();
        return CustomResourceOptions.merge((CustomResourceOptions)defaultOptions, (CustomResourceOptions)options, id);
    }
}

