/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apiextensions.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.apiextensions.v1.outputs.CustomResourceDefinitionSpec;
import com.pulumi.kubernetes.apiextensions.v1.outputs.CustomResourceDefinitionStatus;
import com.pulumi.kubernetes.meta.v1.outputs.ObjectMeta;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CustomResourceDefinition {
    @Nullable
    private String apiVersion;
    @Nullable
    private String kind;
    @Nullable
    private ObjectMeta metadata;
    private CustomResourceDefinitionSpec spec;
    @Nullable
    private CustomResourceDefinitionStatus status;

    private CustomResourceDefinition() {
    }

    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public Optional<String> kind() {
        return Optional.ofNullable(this.kind);
    }

    public Optional<ObjectMeta> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    public CustomResourceDefinitionSpec spec() {
        return this.spec;
    }

    public Optional<CustomResourceDefinitionStatus> status() {
        return Optional.ofNullable(this.status);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomResourceDefinition defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String apiVersion;
        @Nullable
        private String kind;
        @Nullable
        private ObjectMeta metadata;
        private CustomResourceDefinitionSpec spec;
        @Nullable
        private CustomResourceDefinitionStatus status;

        public Builder() {
        }

        public Builder(CustomResourceDefinition defaults) {
            Objects.requireNonNull(defaults);
            this.apiVersion = defaults.apiVersion;
            this.kind = defaults.kind;
            this.metadata = defaults.metadata;
            this.spec = defaults.spec;
            this.status = defaults.status;
        }

        @CustomType.Setter
        public Builder apiVersion(@Nullable String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @CustomType.Setter
        public Builder kind(@Nullable String kind) {
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder metadata(@Nullable ObjectMeta metadata) {
            this.metadata = metadata;
            return this;
        }

        @CustomType.Setter
        public Builder spec(CustomResourceDefinitionSpec spec) {
            if (spec == null) {
                throw new MissingRequiredPropertyException("CustomResourceDefinition", "spec");
            }
            this.spec = spec;
            return this;
        }

        @CustomType.Setter
        public Builder status(@Nullable CustomResourceDefinitionStatus status) {
            this.status = status;
            return this;
        }

        public CustomResourceDefinition build() {
            CustomResourceDefinition _resultValue = new CustomResourceDefinition();
            _resultValue.apiVersion = this.apiVersion;
            _resultValue.kind = this.kind;
            _resultValue.metadata = this.metadata;
            _resultValue.spec = this.spec;
            _resultValue.status = this.status;
            return _resultValue;
        }
    }
}

