/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apiextensions.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class CustomResourceDefinitionNames {
    @Nullable
    private List<String> categories;
    private String kind;
    @Nullable
    private String listKind;
    private String plural;
    @Nullable
    private List<String> shortNames;
    @Nullable
    private String singular;

    private CustomResourceDefinitionNames() {
    }

    public List<String> categories() {
        return this.categories == null ? List.of() : this.categories;
    }

    public String kind() {
        return this.kind;
    }

    public Optional<String> listKind() {
        return Optional.ofNullable(this.listKind);
    }

    public String plural() {
        return this.plural;
    }

    public List<String> shortNames() {
        return this.shortNames == null ? List.of() : this.shortNames;
    }

    public Optional<String> singular() {
        return Optional.ofNullable(this.singular);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CustomResourceDefinitionNames defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<String> categories;
        private String kind;
        @Nullable
        private String listKind;
        private String plural;
        @Nullable
        private List<String> shortNames;
        @Nullable
        private String singular;

        public Builder() {
        }

        public Builder(CustomResourceDefinitionNames defaults) {
            Objects.requireNonNull(defaults);
            this.categories = defaults.categories;
            this.kind = defaults.kind;
            this.listKind = defaults.listKind;
            this.plural = defaults.plural;
            this.shortNames = defaults.shortNames;
            this.singular = defaults.singular;
        }

        @CustomType.Setter
        public Builder categories(@Nullable List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder categories(String ... categories) {
            return this.categories(List.of(categories));
        }

        @CustomType.Setter
        public Builder kind(String kind) {
            if (kind == null) {
                throw new MissingRequiredPropertyException("CustomResourceDefinitionNames", "kind");
            }
            this.kind = kind;
            return this;
        }

        @CustomType.Setter
        public Builder listKind(@Nullable String listKind) {
            this.listKind = listKind;
            return this;
        }

        @CustomType.Setter
        public Builder plural(String plural) {
            if (plural == null) {
                throw new MissingRequiredPropertyException("CustomResourceDefinitionNames", "plural");
            }
            this.plural = plural;
            return this;
        }

        @CustomType.Setter
        public Builder shortNames(@Nullable List<String> shortNames) {
            this.shortNames = shortNames;
            return this;
        }

        public Builder shortNames(String ... shortNames) {
            return this.shortNames(List.of(shortNames));
        }

        @CustomType.Setter
        public Builder singular(@Nullable String singular) {
            this.singular = singular;
            return this;
        }

        public CustomResourceDefinitionNames build() {
            CustomResourceDefinitionNames _resultValue = new CustomResourceDefinitionNames();
            _resultValue.categories = this.categories;
            _resultValue.kind = this.kind;
            _resultValue.listKind = this.listKind;
            _resultValue.plural = this.plural;
            _resultValue.shortNames = this.shortNames;
            _resultValue.singular = this.singular;
            return _resultValue;
        }
    }
}

