/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apiextensions.v1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.apiextensions.v1.outputs.WebhookClientConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class WebhookConversion {
    @Nullable
    private WebhookClientConfig clientConfig;
    private List<String> conversionReviewVersions;

    private WebhookConversion() {
    }

    public Optional<WebhookClientConfig> clientConfig() {
        return Optional.ofNullable(this.clientConfig);
    }

    public List<String> conversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WebhookConversion defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private WebhookClientConfig clientConfig;
        private List<String> conversionReviewVersions;

        public Builder() {
        }

        public Builder(WebhookConversion defaults) {
            Objects.requireNonNull(defaults);
            this.clientConfig = defaults.clientConfig;
            this.conversionReviewVersions = defaults.conversionReviewVersions;
        }

        @CustomType.Setter
        public Builder clientConfig(@Nullable WebhookClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        @CustomType.Setter
        public Builder conversionReviewVersions(List<String> conversionReviewVersions) {
            if (conversionReviewVersions == null) {
                throw new MissingRequiredPropertyException("WebhookConversion", "conversionReviewVersions");
            }
            this.conversionReviewVersions = conversionReviewVersions;
            return this;
        }

        public Builder conversionReviewVersions(String ... conversionReviewVersions) {
            return this.conversionReviewVersions(List.of(conversionReviewVersions));
        }

        public WebhookConversion build() {
            WebhookConversion _resultValue = new WebhookConversion();
            _resultValue.clientConfig = this.clientConfig;
            _resultValue.conversionReviewVersions = this.conversionReviewVersions;
            return _resultValue;
        }
    }
}

