/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apps.v1beta1.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.apps.v1beta1.outputs.StatefulSetUpdateStrategy;
import com.pulumi.kubernetes.core.v1.outputs.PersistentVolumeClaim;
import com.pulumi.kubernetes.core.v1.outputs.PodTemplateSpec;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StatefulSetSpec {
    @Nullable
    private String podManagementPolicy;
    @Nullable
    private Integer replicas;
    @Nullable
    private Integer revisionHistoryLimit;
    @Nullable
    private LabelSelector selector;
    private String serviceName;
    private PodTemplateSpec template;
    @Nullable
    private StatefulSetUpdateStrategy updateStrategy;
    @Nullable
    private List<PersistentVolumeClaim> volumeClaimTemplates;

    private StatefulSetSpec() {
    }

    public Optional<String> podManagementPolicy() {
        return Optional.ofNullable(this.podManagementPolicy);
    }

    public Optional<Integer> replicas() {
        return Optional.ofNullable(this.replicas);
    }

    public Optional<Integer> revisionHistoryLimit() {
        return Optional.ofNullable(this.revisionHistoryLimit);
    }

    public Optional<LabelSelector> selector() {
        return Optional.ofNullable(this.selector);
    }

    public String serviceName() {
        return this.serviceName;
    }

    public PodTemplateSpec template() {
        return this.template;
    }

    public Optional<StatefulSetUpdateStrategy> updateStrategy() {
        return Optional.ofNullable(this.updateStrategy);
    }

    public List<PersistentVolumeClaim> volumeClaimTemplates() {
        return this.volumeClaimTemplates == null ? List.of() : this.volumeClaimTemplates;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StatefulSetSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private String podManagementPolicy;
        @Nullable
        private Integer replicas;
        @Nullable
        private Integer revisionHistoryLimit;
        @Nullable
        private LabelSelector selector;
        private String serviceName;
        private PodTemplateSpec template;
        @Nullable
        private StatefulSetUpdateStrategy updateStrategy;
        @Nullable
        private List<PersistentVolumeClaim> volumeClaimTemplates;

        public Builder() {
        }

        public Builder(StatefulSetSpec defaults) {
            Objects.requireNonNull(defaults);
            this.podManagementPolicy = defaults.podManagementPolicy;
            this.replicas = defaults.replicas;
            this.revisionHistoryLimit = defaults.revisionHistoryLimit;
            this.selector = defaults.selector;
            this.serviceName = defaults.serviceName;
            this.template = defaults.template;
            this.updateStrategy = defaults.updateStrategy;
            this.volumeClaimTemplates = defaults.volumeClaimTemplates;
        }

        @CustomType.Setter
        public Builder podManagementPolicy(@Nullable String podManagementPolicy) {
            this.podManagementPolicy = podManagementPolicy;
            return this;
        }

        @CustomType.Setter
        public Builder replicas(@Nullable Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @CustomType.Setter
        public Builder revisionHistoryLimit(@Nullable Integer revisionHistoryLimit) {
            this.revisionHistoryLimit = revisionHistoryLimit;
            return this;
        }

        @CustomType.Setter
        public Builder selector(@Nullable LabelSelector selector) {
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder serviceName(String serviceName) {
            if (serviceName == null) {
                throw new MissingRequiredPropertyException("StatefulSetSpec", "serviceName");
            }
            this.serviceName = serviceName;
            return this;
        }

        @CustomType.Setter
        public Builder template(PodTemplateSpec template) {
            if (template == null) {
                throw new MissingRequiredPropertyException("StatefulSetSpec", "template");
            }
            this.template = template;
            return this;
        }

        @CustomType.Setter
        public Builder updateStrategy(@Nullable StatefulSetUpdateStrategy updateStrategy) {
            this.updateStrategy = updateStrategy;
            return this;
        }

        @CustomType.Setter
        public Builder volumeClaimTemplates(@Nullable List<PersistentVolumeClaim> volumeClaimTemplates) {
            this.volumeClaimTemplates = volumeClaimTemplates;
            return this;
        }

        public Builder volumeClaimTemplates(PersistentVolumeClaim ... volumeClaimTemplates) {
            return this.volumeClaimTemplates(List.of(volumeClaimTemplates));
        }

        public StatefulSetSpec build() {
            StatefulSetSpec _resultValue = new StatefulSetSpec();
            _resultValue.podManagementPolicy = this.podManagementPolicy;
            _resultValue.replicas = this.replicas;
            _resultValue.revisionHistoryLimit = this.revisionHistoryLimit;
            _resultValue.selector = this.selector;
            _resultValue.serviceName = this.serviceName;
            _resultValue.template = this.template;
            _resultValue.updateStrategy = this.updateStrategy;
            _resultValue.volumeClaimTemplates = this.volumeClaimTemplates;
            return _resultValue;
        }
    }
}

