/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apps.v1beta2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.core.v1.outputs.PodTemplateSpec;
import com.pulumi.kubernetes.meta.v1.outputs.LabelSelector;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ReplicaSetSpec {
    @Nullable
    private Integer minReadySeconds;
    @Nullable
    private Integer replicas;
    private LabelSelector selector;
    @Nullable
    private PodTemplateSpec template;

    private ReplicaSetSpec() {
    }

    public Optional<Integer> minReadySeconds() {
        return Optional.ofNullable(this.minReadySeconds);
    }

    public Optional<Integer> replicas() {
        return Optional.ofNullable(this.replicas);
    }

    public LabelSelector selector() {
        return this.selector;
    }

    public Optional<PodTemplateSpec> template() {
        return Optional.ofNullable(this.template);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReplicaSetSpec defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer minReadySeconds;
        @Nullable
        private Integer replicas;
        private LabelSelector selector;
        @Nullable
        private PodTemplateSpec template;

        public Builder() {
        }

        public Builder(ReplicaSetSpec defaults) {
            Objects.requireNonNull(defaults);
            this.minReadySeconds = defaults.minReadySeconds;
            this.replicas = defaults.replicas;
            this.selector = defaults.selector;
            this.template = defaults.template;
        }

        @CustomType.Setter
        public Builder minReadySeconds(@Nullable Integer minReadySeconds) {
            this.minReadySeconds = minReadySeconds;
            return this;
        }

        @CustomType.Setter
        public Builder replicas(@Nullable Integer replicas) {
            this.replicas = replicas;
            return this;
        }

        @CustomType.Setter
        public Builder selector(LabelSelector selector) {
            if (selector == null) {
                throw new MissingRequiredPropertyException("ReplicaSetSpec", "selector");
            }
            this.selector = selector;
            return this;
        }

        @CustomType.Setter
        public Builder template(@Nullable PodTemplateSpec template) {
            this.template = template;
            return this;
        }

        public ReplicaSetSpec build() {
            ReplicaSetSpec _resultValue = new ReplicaSetSpec();
            _resultValue.minReadySeconds = this.minReadySeconds;
            _resultValue.replicas = this.replicas;
            _resultValue.selector = this.selector;
            _resultValue.template = this.template;
            return _resultValue;
        }
    }
}

