/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.apps.v1beta2.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.apps.v1beta2.outputs.ReplicaSetCondition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ReplicaSetStatus {
    @Nullable
    private Integer availableReplicas;
    @Nullable
    private List<ReplicaSetCondition> conditions;
    @Nullable
    private Integer fullyLabeledReplicas;
    @Nullable
    private Integer observedGeneration;
    @Nullable
    private Integer readyReplicas;
    private Integer replicas;

    private ReplicaSetStatus() {
    }

    public Optional<Integer> availableReplicas() {
        return Optional.ofNullable(this.availableReplicas);
    }

    public List<ReplicaSetCondition> conditions() {
        return this.conditions == null ? List.of() : this.conditions;
    }

    public Optional<Integer> fullyLabeledReplicas() {
        return Optional.ofNullable(this.fullyLabeledReplicas);
    }

    public Optional<Integer> observedGeneration() {
        return Optional.ofNullable(this.observedGeneration);
    }

    public Optional<Integer> readyReplicas() {
        return Optional.ofNullable(this.readyReplicas);
    }

    public Integer replicas() {
        return this.replicas;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ReplicaSetStatus defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private Integer availableReplicas;
        @Nullable
        private List<ReplicaSetCondition> conditions;
        @Nullable
        private Integer fullyLabeledReplicas;
        @Nullable
        private Integer observedGeneration;
        @Nullable
        private Integer readyReplicas;
        private Integer replicas;

        public Builder() {
        }

        public Builder(ReplicaSetStatus defaults) {
            Objects.requireNonNull(defaults);
            this.availableReplicas = defaults.availableReplicas;
            this.conditions = defaults.conditions;
            this.fullyLabeledReplicas = defaults.fullyLabeledReplicas;
            this.observedGeneration = defaults.observedGeneration;
            this.readyReplicas = defaults.readyReplicas;
            this.replicas = defaults.replicas;
        }

        @CustomType.Setter
        public Builder availableReplicas(@Nullable Integer availableReplicas) {
            this.availableReplicas = availableReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder conditions(@Nullable List<ReplicaSetCondition> conditions) {
            this.conditions = conditions;
            return this;
        }

        public Builder conditions(ReplicaSetCondition ... conditions) {
            return this.conditions(List.of(conditions));
        }

        @CustomType.Setter
        public Builder fullyLabeledReplicas(@Nullable Integer fullyLabeledReplicas) {
            this.fullyLabeledReplicas = fullyLabeledReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder observedGeneration(@Nullable Integer observedGeneration) {
            this.observedGeneration = observedGeneration;
            return this;
        }

        @CustomType.Setter
        public Builder readyReplicas(@Nullable Integer readyReplicas) {
            this.readyReplicas = readyReplicas;
            return this;
        }

        @CustomType.Setter
        public Builder replicas(Integer replicas) {
            if (replicas == null) {
                throw new MissingRequiredPropertyException("ReplicaSetStatus", "replicas");
            }
            this.replicas = replicas;
            return this;
        }

        public ReplicaSetStatus build() {
            ReplicaSetStatus _resultValue = new ReplicaSetStatus();
            _resultValue.availableReplicas = this.availableReplicas;
            _resultValue.conditions = this.conditions;
            _resultValue.fullyLabeledReplicas = this.fullyLabeledReplicas;
            _resultValue.observedGeneration = this.observedGeneration;
            _resultValue.readyReplicas = this.readyReplicas;
            _resultValue.replicas = this.replicas;
            return _resultValue;
        }
    }
}

