/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.kubernetes.autoscaling.v1.inputs;

import com.pulumi.core.Output;
import com.pulumi.core.annotations.Import;
import com.pulumi.exceptions.MissingRequiredPropertyException;
import com.pulumi.kubernetes.autoscaling.v1.inputs.CrossVersionObjectReferenceArgs;
import com.pulumi.resources.ResourceArgs;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class HorizontalPodAutoscalerSpecArgs
extends ResourceArgs {
    public static final HorizontalPodAutoscalerSpecArgs Empty = new HorizontalPodAutoscalerSpecArgs();
    @Import(name="maxReplicas", required=true)
    private Output<Integer> maxReplicas;
    @Import(name="minReplicas")
    @Nullable
    private Output<Integer> minReplicas;
    @Import(name="scaleTargetRef", required=true)
    private Output<CrossVersionObjectReferenceArgs> scaleTargetRef;
    @Import(name="targetCPUUtilizationPercentage")
    @Nullable
    private Output<Integer> targetCPUUtilizationPercentage;

    public Output<Integer> maxReplicas() {
        return this.maxReplicas;
    }

    public Optional<Output<Integer>> minReplicas() {
        return Optional.ofNullable(this.minReplicas);
    }

    public Output<CrossVersionObjectReferenceArgs> scaleTargetRef() {
        return this.scaleTargetRef;
    }

    public Optional<Output<Integer>> targetCPUUtilizationPercentage() {
        return Optional.ofNullable(this.targetCPUUtilizationPercentage);
    }

    private HorizontalPodAutoscalerSpecArgs() {
    }

    private HorizontalPodAutoscalerSpecArgs(HorizontalPodAutoscalerSpecArgs $) {
        this.maxReplicas = $.maxReplicas;
        this.minReplicas = $.minReplicas;
        this.scaleTargetRef = $.scaleTargetRef;
        this.targetCPUUtilizationPercentage = $.targetCPUUtilizationPercentage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HorizontalPodAutoscalerSpecArgs defaults) {
        return new Builder(defaults);
    }

    public static final class Builder {
        private HorizontalPodAutoscalerSpecArgs $;

        public Builder() {
            this.$ = new HorizontalPodAutoscalerSpecArgs();
        }

        public Builder(HorizontalPodAutoscalerSpecArgs defaults) {
            this.$ = new HorizontalPodAutoscalerSpecArgs(Objects.requireNonNull(defaults));
        }

        public Builder maxReplicas(Output<Integer> maxReplicas) {
            this.$.maxReplicas = maxReplicas;
            return this;
        }

        public Builder maxReplicas(Integer maxReplicas) {
            return this.maxReplicas((Output<Integer>)Output.of((Object)maxReplicas));
        }

        public Builder minReplicas(@Nullable Output<Integer> minReplicas) {
            this.$.minReplicas = minReplicas;
            return this;
        }

        public Builder minReplicas(Integer minReplicas) {
            return this.minReplicas((Output<Integer>)Output.of((Object)minReplicas));
        }

        public Builder scaleTargetRef(Output<CrossVersionObjectReferenceArgs> scaleTargetRef) {
            this.$.scaleTargetRef = scaleTargetRef;
            return this;
        }

        public Builder scaleTargetRef(CrossVersionObjectReferenceArgs scaleTargetRef) {
            return this.scaleTargetRef((Output<CrossVersionObjectReferenceArgs>)Output.of((Object)((Object)scaleTargetRef)));
        }

        public Builder targetCPUUtilizationPercentage(@Nullable Output<Integer> targetCPUUtilizationPercentage) {
            this.$.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
            return this;
        }

        public Builder targetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
            return this.targetCPUUtilizationPercentage((Output<Integer>)Output.of((Object)targetCPUUtilizationPercentage));
        }

        public HorizontalPodAutoscalerSpecArgs build() {
            if (this.$.maxReplicas == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpecArgs", "maxReplicas");
            }
            if (this.$.scaleTargetRef == null) {
                throw new MissingRequiredPropertyException("HorizontalPodAutoscalerSpecArgs", "scaleTargetRef");
            }
            return this.$;
        }
    }
}

